/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.service;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.FileSystemUtils;

@Service
public class LocalStorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalStorageService.class);
    private final AppPreferences appPreferences;
    Path tempRootPath;

    @PostConstruct
    public void init() throws IOException {
        this.tempRootPath = Files.createTempDirectory("SITC-Dms", new FileAttribute[0]);
        this.appPreferences.getShutdownHooks().add(this::onShutdown);
    }

    public void storeFile(String fileId, byte[] content) {
        try {
            Files.write(this.getTempFilePath(fileId), content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getTempFilePath(String fileId) {
        return Paths.get(this.tempRootPath.toString(), fileId);
    }

    private void onShutdown(AppPreferences appPreferences) {
        try {
            if (FileSystemUtils.deleteRecursively((Path)this.tempRootPath)) {
                log.info("Clean up of temporary local storage successful.");
            }
        }
        catch (IOException e) {
            log.warn("Failed to delete temporary directory: {}", (Object)this.tempRootPath, (Object)e);
        }
    }

    @Generated
    public LocalStorageService(AppPreferences appPreferences) {
        this.appPreferences = appPreferences;
    }
}

