/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import net.schembs.solutions.dms.client.exception.DocumentExportException;
import net.schembs.solutions.dms.client.exception.DocumentsExportAsZipException;
import net.schembs.solutions.dms.client.exception.DocumentsExportException;
import net.schembs.solutions.dms.client.model.DmsDocument;
import net.schembs.solutions.dms.client.service.ClientService;
import net.schembs.solutions.dms.client.service.DocumentFilenameService;
import net.schembs.solutions.dms.client.service.DocumentStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ExportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportService.class);
    private final DocumentStoreService documentStoreService;
    private final ClientService clientService;
    private final DocumentFilenameService documentFilenameService;

    @Async
    public CompletableFuture<DmsDocument> exportDocument(File f, DmsDocument document) {
        try {
            byte[] data = this.loadDocument(document);
            Files.write(f.toPath(), data, new OpenOption[0]);
            return CompletableFuture.completedFuture(document);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new DocumentExportException(e));
        }
    }

    @Async
    public CompletableFuture<Void> createZip(File file, List<DmsDocument> documents) {
        log.info("Try to create zip {} with {} documents", (Object)file.getName(), (Object)documents.size());
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));){
            for (DmsDocument dmsDocument : documents) {
                ZipEntry e = new ZipEntry(this.documentFilenameService.getFilenameForDescription(dmsDocument));
                out.putNextEntry(e);
                byte[] data = this.loadDocument(dmsDocument);
                out.write(data, 0, data.length);
                out.closeEntry();
            }
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new DocumentsExportAsZipException(e));
        }
        return CompletableFuture.completedFuture(null);
    }

    private byte[] loadDocument(DmsDocument dmsDocument) {
        return this.documentStoreService.loadDocument(dmsDocument.getId());
    }

    public CompletableFuture<Void> exportDocuments(File folder, List<DmsDocument> documents) {
        ArrayList<DmsDocument> failedDocuments = new ArrayList<DmsDocument>();
        for (DmsDocument document : documents) {
            Path targetPath = folder.toPath().resolve(this.documentFilenameService.getFilenameForDescription(document));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                byte[] data = this.loadDocument(document);
                try {
                    Files.write(targetPath, data, new OpenOption[0]);
                }
                catch (IOException e) {
                    failedDocuments.add(document);
                }
                continue;
            }
            failedDocuments.add(document);
        }
        return failedDocuments.isEmpty() ? CompletableFuture.completedFuture(null) : CompletableFuture.failedFuture(new DocumentsExportException(failedDocuments));
    }

    @Generated
    public ExportService(DocumentStoreService documentStoreService, ClientService clientService, DocumentFilenameService documentFilenameService) {
        this.documentStoreService = documentStoreService;
        this.clientService = clientService;
        this.documentFilenameService = documentFilenameService;
    }
}

