/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.service;

import java.util.List;
import lombok.Generated;
import net.schembs.solutions.dms.client.client.api.model.Client;
import net.schembs.solutions.dms.client.client.api.model.TagTreeNode;
import net.schembs.solutions.dms.client.client.api.model.TreeChange;
import net.schembs.solutions.dms.client.document.api.model.AnalyzedDocument;
import net.schembs.solutions.dms.client.document.api.model.DocumentChangeRequest;
import net.schembs.solutions.dms.client.document.api.model.DocumentContent;
import net.schembs.solutions.dms.client.document.api.model.DocumentCreateRequest;
import net.schembs.solutions.dms.client.document.api.model.DocumentCreateResponse;
import net.schembs.solutions.dms.client.document.api.model.DocumentDataChangeRequest;
import net.schembs.solutions.dms.client.document.api.model.DocumentGetResponse;
import net.schembs.solutions.dms.client.document.api.model.DocumentMetadata;
import net.schembs.solutions.dms.client.document.api.model.DocumentSearchResult;
import net.schembs.solutions.dms.client.model.DmsDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class DocumentStoreService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentStoreService.class);
    private static final String ROOT_PATH = "/v2/documents";
    private final RestTemplate documentStoreRestTemplate;

    public Client loadClientData() {
        return (Client)this.documentStoreRestTemplate.getForObject("/clients/get", Client.class, new Object[0]);
    }

    public Client[] loadAllClients() {
        return (Client[])this.documentStoreRestTemplate.getForObject("/clients/list/all", Client[].class, new Object[0]);
    }

    public DocumentMetadata[] loadDocumentsForTag(String tag) {
        return (DocumentMetadata[])this.documentStoreRestTemplate.getForObject(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/list").queryParam("tag", new Object[]{tag}).toUriString(), DocumentMetadata[].class, new Object[0]);
    }

    public Long uploadDocument(String name, String description, byte[] data) {
        DocumentCreateRequest request = DocumentCreateRequest.builder().name(name).description(description).data(data).build();
        DocumentCreateResponse response = (DocumentCreateResponse)this.documentStoreRestTemplate.postForObject("/v2/documents/create", (Object)request, DocumentCreateResponse.class, new Object[0]);
        return response.getId();
    }

    public TagTreeNode updateClientTagTree(List<TreeChange> changes) {
        return (TagTreeNode)this.documentStoreRestTemplate.patchForObject(UriComponentsBuilder.fromUriString((String)"/clients/").path("/tags/tree").toUriString(), changes, TagTreeNode.class, new Object[0]);
    }

    public byte[] loadDocument(Long id) {
        DocumentGetResponse response = (DocumentGetResponse)this.documentStoreRestTemplate.getForObject(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/").path(id.toString()).toUriString(), DocumentGetResponse.class, new Object[0]);
        return response != null ? response.getData() : null;
    }

    public void addDocumentTag(Long documentId, String tag) {
        log.info("Call add tag backend for {} with tag {}", (Object)documentId, (Object)tag);
        this.documentStoreRestTemplate.patchForObject(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/").path(documentId.toString()).path("/tags/").path(tag).toUriString(), null, String.class, new Object[0]);
    }

    public void removeDocumentTag(Long documentId, String tag) {
        log.info("Call remove tag backend for {} with tag {}", (Object)documentId, (Object)tag);
        this.documentStoreRestTemplate.delete(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/").path(documentId.toString()).path("/tags/").path(tag).toUriString(), new Object[]{null, String.class});
    }

    public void removeDocumentTags(Long documentId) {
        log.info("Call remove tags backend for {}", (Object)documentId);
        this.documentStoreRestTemplate.delete(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/").path(documentId.toString()).path("/tags").toUriString(), new Object[]{null, String.class});
    }

    public void deleteDocument(Long documentId) {
        log.info("Call delete document for {}", (Object)documentId);
        this.documentStoreRestTemplate.delete(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/").path(documentId.toString()).toUriString(), new Object[]{null, String.class});
    }

    public void removeTagFromAllDocuments(String tag) {
        log.info("Call remove tag from all documents for {}", (Object)tag);
        this.documentStoreRestTemplate.delete(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/tags/").path(tag).toUriString(), new Object[]{null, String.class});
    }

    public void updateDocument(DmsDocument document) {
        log.info("Call update document {}", (Object)document.getId());
        DocumentChangeRequest request = DocumentChangeRequest.builder().description(document.getDescription()).status(document.getStatus().name()).documentDate(document.getDocumentDate()).assignee(document.getAssignee()).owner(document.getOwner()).build();
        this.documentStoreRestTemplate.patchForObject(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/").path(document.getId().toString()).toUriString(), (Object)request, String.class, new Object[0]);
    }

    public TagTreeNode loadClientTagTree() {
        return (TagTreeNode)this.documentStoreRestTemplate.getForObject(UriComponentsBuilder.fromUriString((String)"/clients/").path("/tags/tree").toUriString(), TagTreeNode.class, new Object[0]);
    }

    public void updateDocumentData(Long documentId, byte[] data) {
        this.documentStoreRestTemplate.put(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/").path(documentId.toString()).toUriString(), (Object)new DocumentDataChangeRequest().data(data), new Object[]{String.class});
    }

    public String[] getDocumentTags(Long documentId) {
        return (String[])this.documentStoreRestTemplate.getForObject(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/").path(documentId.toString()).path("/tags").queryParam("type", new Object[]{"path"}).toUriString(), String[].class, new Object[0]);
    }

    public String[] getExistingDescriptions() {
        return (String[])this.documentStoreRestTemplate.getForObject(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/descriptions").toUriString(), String[].class, new Object[0]);
    }

    public DocumentSearchResult[] findDocumentsWithText(String text) {
        return (DocumentSearchResult[])this.documentStoreRestTemplate.getForObject(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/find").queryParam("text", new Object[]{text}).build(false).toUriString(), DocumentSearchResult[].class, new Object[0]);
    }

    public List<DocumentContent> getDocumentAnalyzedContent(Long documentId) {
        AnalyzedDocument analyzedDocument = (AnalyzedDocument)this.documentStoreRestTemplate.getForObject(UriComponentsBuilder.fromUriString((String)ROOT_PATH).path("/").path(documentId.toString()).path("/analyzed").queryParam("type", new Object[]{"path"}).toUriString(), AnalyzedDocument.class, new Object[0]);
        return analyzedDocument.getContent();
    }

    @Generated
    public DocumentStoreService(RestTemplate documentStoreRestTemplate) {
        this.documentStoreRestTemplate = documentStoreRestTemplate;
    }
}

