/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import net.schembs.solutions.dms.client.document.api.model.DocumentMetadata;
import net.schembs.solutions.dms.client.exception.DocumentAddTagFailedException;
import net.schembs.solutions.dms.client.exception.DocumentDeleteFailedException;
import net.schembs.solutions.dms.client.exception.DocumentDescriptionsLoadFailedException;
import net.schembs.solutions.dms.client.exception.DocumentLoadAnaylzedContentException;
import net.schembs.solutions.dms.client.exception.DocumentLoadContentException;
import net.schembs.solutions.dms.client.exception.DocumentLoadListForTagException;
import net.schembs.solutions.dms.client.exception.DocumentLoadTagsException;
import net.schembs.solutions.dms.client.exception.DocumentRemoveTagFailedException;
import net.schembs.solutions.dms.client.exception.DocumentUpdateFailedException;
import net.schembs.solutions.dms.client.exception.DocumentUploadException;
import net.schembs.solutions.dms.client.exception.TagRemoveFromAllDocumentsFailedException;
import net.schembs.solutions.dms.client.model.DmsDocument;
import net.schembs.solutions.dms.client.model.DocumentStatus;
import net.schembs.solutions.dms.client.model.DocumentWord;
import net.schembs.solutions.dms.client.model.Tag;
import net.schembs.solutions.dms.client.service.DocumentStoreService;
import net.schembs.solutions.dms.client.service.LocalStorageService;
import net.schembs.solutions.dms.client.ui.general.tag.tree.DefaultTagTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class DocumentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentService.class);
    private final DocumentStoreService documentStoreService;
    private final LocalStorageService localStorageService;

    @Async
    public CompletableFuture<Long> uploadDocument(String name, String description, File file) {
        try {
            byte[] data;
            log.info("Uploading document...");
            try {
                data = Files.readAllBytes(file.toPath());
            }
            catch (IOException e) {
                return CompletableFuture.failedFuture(e);
            }
            Long id = this.documentStoreService.uploadDocument(name, description, data);
            log.info("Document uploaded with id {}.", (Object)id);
            return CompletableFuture.completedFuture(id);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new DocumentUploadException(e, name));
        }
    }

    @Async
    public CompletableFuture<List<DmsDocument>> loadDocumentsForTag(Tag tag) {
        try {
            log.info("Loading documents...");
            List<DmsDocument> documents = Arrays.stream(this.documentStoreService.loadDocumentsForTag(tag.getValue())).map(DocumentService::mapDocumentMetaDataToDMSDocument).toList();
            log.info("Documents loaded.");
            return CompletableFuture.completedFuture(documents);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new DocumentLoadListForTagException(e, tag));
        }
    }

    private static DmsDocument mapDocumentMetaDataToDMSDocument(DocumentMetadata metadata) {
        return DmsDocument.builder().id(metadata.getId()).name(metadata.getName()).description(metadata.getDescription()).status(DocumentStatus.valueOf(metadata.getStatus())).storageId(UUID.randomUUID().toString()).changeUser(metadata.getChangeUser()).changeDate(metadata.getChangeDate()).createDate(metadata.getCreateDate()).createUser(metadata.getCreateUser()).owner(metadata.getOwner()).assignee(metadata.getAssignee()).documentDate(metadata.getDocumentDate()).build();
    }

    @Async
    public CompletableFuture<DmsDocument> loadDocument(DmsDocument dmsDocument) {
        try {
            byte[] data = this.documentStoreService.loadDocument(dmsDocument.getId());
            this.localStorageService.storeFile(dmsDocument.getStorageId(), data);
            return CompletableFuture.completedFuture(dmsDocument);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new DocumentLoadContentException(e, dmsDocument));
        }
    }

    @Async
    public CompletableFuture<Void> addTagToDocuments(List<DmsDocument> dmsDocuments, Tag tag) {
        for (DmsDocument dmsDocument : dmsDocuments) {
            try {
                this.documentStoreService.addDocumentTag(dmsDocument.getId(), tag.getValue());
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(new DocumentAddTagFailedException(e, dmsDocument));
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Async
    public CompletableFuture<Void> switchTagForDocuments(List<DmsDocument> dmsDocuments, Tag tagToAdd, Tag tagToRemove) {
        for (DmsDocument dmsDocument : dmsDocuments) {
            try {
                this.documentStoreService.addDocumentTag(dmsDocument.getId(), tagToAdd.getValue());
                this.documentStoreService.removeDocumentTag(dmsDocument.getId(), tagToRemove.getValue());
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(new DocumentRemoveTagFailedException(e, dmsDocument));
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<Void> removeDocumentsFromTag(List<DmsDocument> dmsDocuments, Tag tag) {
        for (DmsDocument dmsDocument : dmsDocuments) {
            try {
                this.documentStoreService.removeDocumentTag(dmsDocument.getId(), tag.getValue());
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(new DocumentAddTagFailedException(e, dmsDocument));
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Async
    public CompletableFuture<Void> moveToTrashTagForDocuments(List<DmsDocument> dmsDocuments) {
        for (DmsDocument dmsDocument : dmsDocuments) {
            try {
                this.documentStoreService.removeDocumentTags(dmsDocument.getId());
                this.documentStoreService.addDocumentTag(dmsDocument.getId(), Tag.getTrash().getId());
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(new DocumentRemoveTagFailedException(e, dmsDocument));
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Async
    public CompletableFuture<Void> deleteDocument(List<DmsDocument> dmsDocuments) {
        for (DmsDocument dmsDocument : dmsDocuments) {
            try {
                this.documentStoreService.deleteDocument(dmsDocument.getId());
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(new DocumentDeleteFailedException(e, dmsDocument));
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Async
    public CompletableFuture<DefaultTagTreeNode> removeAllDocumentsFromTag(DefaultTagTreeNode tagNode) {
        try {
            this.documentStoreService.removeTagFromAllDocuments(tagNode.getTag().getValue());
            return CompletableFuture.completedFuture(tagNode);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new TagRemoveFromAllDocumentsFailedException(e, tagNode.getTag()));
        }
    }

    @Async
    public CompletableFuture<Void> updateDocument(DmsDocument document) {
        try {
            this.documentStoreService.updateDocument(document);
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new DocumentUpdateFailedException(e, document));
        }
    }

    @Async
    public CompletableFuture<DmsDocument> updateDocumentData(DmsDocument document, File file) {
        try {
            byte[] data;
            try {
                data = Files.readAllBytes(file.toPath());
            }
            catch (IOException e) {
                return CompletableFuture.failedFuture(e);
            }
            this.documentStoreService.updateDocumentData(document.getId(), data);
            return CompletableFuture.completedFuture(document);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new DocumentUpdateFailedException(e, document));
        }
    }

    @Async
    public CompletableFuture<List<String>> getDocumentTags(DmsDocument document) {
        try {
            return CompletableFuture.completedFuture(new ArrayList<String>(Arrays.asList(this.documentStoreService.getDocumentTags(document.getId()))));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new DocumentLoadTagsException(e, document));
        }
    }

    @Async
    public CompletableFuture<List<String>> loadExistingDescriptions() {
        try {
            return CompletableFuture.completedFuture(Arrays.asList(this.documentStoreService.getExistingDescriptions()));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new DocumentDescriptionsLoadFailedException(e));
        }
    }

    public CompletableFuture<List<DocumentWord>> loadAnalyzedContentFor(DmsDocument document) {
        try {
            return CompletableFuture.completedFuture(this.documentStoreService.getDocumentAnalyzedContent(document.getId()).stream().map(w -> DocumentWord.builder().word(w.getWord()).value(w.getValue()).weight(w.getWeight()).build()).toList());
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new DocumentLoadAnaylzedContentException(e, document));
        }
    }

    @Generated
    public DocumentService(DocumentStoreService documentStoreService, LocalStorageService localStorageService) {
        this.documentStoreService = documentStoreService;
        this.localStorageService = localStorageService;
    }
}

