/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.service;

import java.util.List;
import lombok.Generated;
import net.schembs.solutions.dms.client.client.api.model.TagTreeNode;
import net.schembs.solutions.dms.client.client.api.model.TreeChange;
import net.schembs.solutions.dms.client.model.Client;
import net.schembs.solutions.dms.client.service.DocumentStoreService;
import net.schembs.solutions.dms.security.model.User;
import org.springframework.stereotype.Service;

@Service
public class ClientService {
    private final DocumentStoreService documentStoreService;
    private Client client;

    public void loadClientDataForUser(User user) {
        net.schembs.solutions.dms.client.client.api.model.Client clientData = this.documentStoreService.loadClientData();
        this.client = Client.builder().title(clientData.getName()).tagTree(clientData.getTagTree()).build();
    }

    public TagTreeNode updateClientTagTree(List<TreeChange> treeChanges) {
        return this.documentStoreService.updateClientTagTree(treeChanges);
    }

    public void reloadClientTagTree() {
        TagTreeNode tagTreeNode = this.documentStoreService.loadClientTagTree();
        this.updateTree(tagTreeNode);
    }

    public void updateTree(TagTreeNode tagTreeNode) {
        this.client.setTagTree(tagTreeNode);
    }

    public void clearClient() {
        this.client = null;
    }

    @Generated
    public ClientService(DocumentStoreService documentStoreService) {
        this.documentStoreService = documentStoreService;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }
}

