/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.service;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.schembs.solutions.dms.client.admin.api.model.CreateUserRequest;
import net.schembs.solutions.dms.client.admin.api.model.CreateUserResponse;
import net.schembs.solutions.dms.client.admin.api.model.User;
import net.schembs.solutions.dms.client.model.DmsUser;
import net.schembs.solutions.dms.client.service.DocumentStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AdminService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminService.class);
    private final RestTemplate authServerAdminRestTemplate;
    private final DocumentStoreService documentStoreService;

    @Async
    public CompletableFuture<List<DmsUser>> loadUsers() {
        try {
            User[] users = Optional.ofNullable((User[])this.authServerAdminRestTemplate.getForObject("/users", User[].class, new Object[0])).orElse(new User[0]);
            return CompletableFuture.completedFuture(Arrays.stream(users).map(user -> DmsUser.builder().username(user.getUsername()).fullName(user.getFullName()).build()).toList());
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Async
    public CompletableFuture<DmsUser> loadUser(String username) {
        try {
            User user = (User)this.authServerAdminRestTemplate.getForObject("/users/" + username, User.class, new Object[0]);
            return CompletableFuture.completedFuture(user != null ? DmsUser.builder().username(user.getUsername()).fullName(user.getFullName()).roles(user.getRoles()).build() : null);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public void createUser(DmsUser dmsUser) {
        CreateUserRequest request = new CreateUserRequest();
        request.setUsername(dmsUser.getUsername());
        request.setPassword(dmsUser.getPassword());
        request.setFullName(dmsUser.getFullName());
        request.setRoles(dmsUser.getRoles());
        this.authServerAdminRestTemplate.postForObject("/users", (Object)request, CreateUserResponse.class, new Object[0]);
    }

    public void updateUser(String username, DmsUser dmsUser) {
        String password;
        User user = new User();
        user.setUsername(dmsUser.getUsername());
        user.setFullName(dmsUser.getFullName());
        String string = password = dmsUser.getPassword() != null ? dmsUser.getPassword().trim() : "";
        if (!password.isEmpty()) {
            user.setPassword(password);
        }
        user.setRoles(dmsUser.getRoles());
        this.authServerAdminRestTemplate.patchForObject("/users/" + username, (Object)user, Void.class, new Object[0]);
    }

    @Generated
    public AdminService(RestTemplate authServerAdminRestTemplate, DocumentStoreService documentStoreService) {
        this.authServerAdminRestTemplate = authServerAdminRestTemplate;
        this.documentStoreService = documentStoreService;
    }
}

