/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.controller;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.swing.JOptionPane;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.ui.UIUtils;
import net.schembs.solutions.dms.client.client.api.model.TagTreeNode;
import net.schembs.solutions.dms.client.client.api.model.TreeChange;
import net.schembs.solutions.dms.client.controller.ErrorController;
import net.schembs.solutions.dms.client.exception.TagRemoveFromAllDocumentsFailedException;
import net.schembs.solutions.dms.client.model.Actions;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.model.Client;
import net.schembs.solutions.dms.client.model.ErrorCode;
import net.schembs.solutions.dms.client.model.Tag;
import net.schembs.solutions.dms.client.model.TreeDeltaNode;
import net.schembs.solutions.dms.client.service.ClientService;
import net.schembs.solutions.dms.client.service.DocumentService;
import net.schembs.solutions.dms.client.service.SearchService;
import net.schembs.solutions.dms.client.ui.general.tag.tree.DefaultTagTreeNode;
import net.schembs.solutions.dms.client.ui.general.tag.tree.TagTreePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class TagController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TagController.class);
    private final TagTreePanel tagTreePanel;
    private final ClientService clientService;
    private final ActionService actionService;
    private final I18nService i18n;
    private final DocumentService documentService;
    private final ErrorController errorController;
    private final SettingsService<AppSettings> settingsService;
    private final DefaultTagTreeNode clientTreeRoot = new DefaultTagTreeNode();
    private final DefaultTagTreeNode searchResults = new DefaultTagTreeNode();
    private final UIUtils uiUtils;
    private final SearchService searchService;

    @PostConstruct
    public void init() {
        this.configureActions();
        this.tagTreePanel.getTagTreeChangedListeners().add(this::onTreeChanged);
    }

    private void configureActions() {
        this.actionService.getAction(Actions.tagAdd).setActionListener(e -> this.onAddTag(this.tagTreePanel.getPopupMenuActionNodeOrSelectedNode()));
        this.actionService.getAction(Actions.tagDelete).setActionListener(e -> this.onDeleteTag(this.tagTreePanel.getPopupMenuActionNodeOrSelectedNode()));
        this.actionService.getAction(Actions.tagRename).setActionListener(e -> this.onRenameTag(this.tagTreePanel.getPopupMenuActionNodeOrSelectedNode()));
        this.actionService.getAction(Actions.tagsReload).setActionListener(e -> this.onReloadTags());
        this.actionService.getAction(Actions.searchRemoveResult).setActionListener(e -> this.onRemoveSearchResult());
        this.actionService.getAction(Actions.searchRemoveAllResults).setActionListener(e -> this.onRemoveAllSearchResults());
    }

    public void initTreeWithUserData() {
        Client client = this.clientService.getClient();
        if (client != null) {
            log.info("Initializing tag tree for client: {}", (Object)client);
            this.tagTreePanel.getRootNode().removeAllChildren();
            this.tagTreePanel.getRootNode().setUserObject(Tag.builder().id("8ff476fb-f66d-40e8-8bc6-c87303d6954e").build());
            this.clientTreeRoot.removeAllChildren();
            this.createViewModel(this.clientTreeRoot, client.getTagTree());
            this.tagTreePanel.getRootNode().add(this.clientTreeRoot);
            this.searchResults.setUserObject(Tag.builder().id("8ff476fb-f66d-40e8-8bc6-c87303d6954e").name(this.i18n.t("tagTree.search.results.title", new Object[0])).build());
            this.searchResults.removeAllChildren();
            this.tagTreePanel.getRootNode().add(this.searchResults);
            this.tagTreePanel.fireNodeStructureChanged(this.tagTreePanel.getRootNode());
            this.tagTreePanel.onNewViewModel();
            this.tagTreePanel.selectNode(this.clientTreeRoot);
        } else {
            this.tagTreePanel.onClearViewModel();
        }
    }

    private DefaultTagTreeNode createViewModel(DefaultTagTreeNode node, TagTreeNode tagTreeNode) {
        node.setTag(Tag.builder().id(tagTreeNode.getId() != null ? tagTreeNode.getId().toString() : null).name(tagTreeNode.getName()).expanded(!Boolean.FALSE.equals(tagTreeNode.getExpanded())).query(Boolean.TRUE.equals(tagTreeNode.getQuery())).build());
        if (tagTreeNode.getChildren() != null) {
            for (TagTreeNode child : tagTreeNode.getChildren()) {
                node.add(this.createViewModel(new DefaultTagTreeNode(), child));
            }
        }
        return node;
    }

    private TagTreeNode extractModelFromViewModel(DefaultTagTreeNode node) {
        Tag sourceModel = node.getTag();
        TagTreeNode targetModel = new TagTreeNode();
        targetModel.setId(sourceModel.getId() != null ? UUID.fromString(sourceModel.getId()) : null);
        targetModel.setName(sourceModel.getName());
        targetModel.setExpanded(sourceModel.isExpanded());
        if (node.getChildCount() > 0) {
            targetModel.setChildren(new ArrayList<TagTreeNode>());
            for (int i = 0; i < node.getChildCount(); ++i) {
                Objects.requireNonNull(targetModel.getChildren()).add(this.extractModelFromViewModel(node.getTagTreeNodeChildAt(i)));
            }
        }
        return targetModel;
    }

    private void onAddTag(DefaultTagTreeNode parentNode) {
        log.info("Add tag for {}", (Object)parentNode);
        Tag tag = Tag.builder().id(UUID.randomUUID().toString()).name(this.i18n.t("tagTree.newNode", new Object[0])).build();
        DefaultTagTreeNode newChild = new DefaultTagTreeNode(tag);
        parentNode.add(newChild);
        this.tagTreePanel.onNodeAdded(parentNode, newChild);
    }

    private void onDeleteTag(DefaultTagTreeNode tagNode) {
        if (tagNode != null && tagNode.getTag() != null && !tagNode.getTag().isSpecialTag()) {
            if (!tagNode.getTag().isSearchResult()) {
                if (!Boolean.FALSE.equals(this.settingsService.getAppSettings().getApp().getConfirmDeleteTag()) && JOptionPane.showConfirmDialog(this.uiUtils.findMainFrame(this.tagTreePanel), this.i18n.t("confirm.delete.tag", tagNode.getTag().getName()), this.i18n.t("confirm.title", new Object[0]), 0) != 0) {
                    return;
                }
                ((CompletableFuture)this.documentService.removeAllDocumentsFromTag(tagNode).thenAccept(this::onTagRemovedFromAllDocuments)).exceptionally(this::onTagRemoveFromAllDocumentsFailed);
            } else {
                this.removeSearchResult(tagNode);
            }
        }
    }

    private void onRenameTag(DefaultTagTreeNode node) {
        if (node != null && node.getTag() != null && !node.getTag().isRoot()) {
            this.tagTreePanel.startEditing(node);
        }
    }

    private void onTagRemovedFromAllDocuments(DefaultTagTreeNode tagNode) {
        this.tagTreePanel.onNodeRemoved(tagNode);
        this.storeProperties();
    }

    private Void onTagRemoveFromAllDocumentsFailed(Throwable t) {
        this.errorController.findException(t, TagRemoveFromAllDocumentsFailedException.class).ifPresentOrElse(tagRemoveFromAllDocumentsFailedException -> this.errorController.handleError(ErrorCode.tagRemoveFromAllDocumentsFailed, (Throwable)tagRemoveFromAllDocumentsFailedException, tagRemoveFromAllDocumentsFailedException.getTag().getName()), () -> this.errorController.handleError(ErrorCode.tagRemoveFromAllDocumentsFailed, t, new Object[0]));
        return null;
    }

    private void storeProperties() {
        List<TreeChange> changes = this.calculateTreeChanges();
        if (!changes.isEmpty()) {
            TagTreeNode tagTreeNode = this.clientService.updateClientTagTree(changes);
            this.clientService.updateTree(tagTreeNode);
        }
    }

    private void onTreeChanged() {
        this.storeProperties();
    }

    private void onReloadTags() {
        this.clientService.reloadClientTagTree();
        this.initTreeWithUserData();
    }

    private List<TreeChange> calculateTreeChanges() {
        TreeDeltaNode oldModel = new TreeDeltaNode();
        HashMap<String, TreeDeltaNode> oldModelMap = new HashMap<String, TreeDeltaNode>();
        this.wrapTree(this.clientService.getClient().getTagTree(), oldModel, oldModelMap);
        TreeDeltaNode newModel = new TreeDeltaNode();
        HashMap<String, TreeDeltaNode> newModelMap = new HashMap<String, TreeDeltaNode>();
        this.wrapTree(this.extractModelFromViewModel(this.clientTreeRoot), newModel, newModelMap);
        ArrayList<TreeChange> changes = new ArrayList<TreeChange>();
        this.walkNodes(newModel, oldModelMap, changes);
        for (String oldModelKey : oldModelMap.keySet()) {
            if (newModelMap.containsKey(oldModelKey)) continue;
            changes.add(new TreeChange().changeType(TreeChange.ChangeTypeEnum.DELETE_NODE).node(((TreeDeltaNode)oldModelMap.get(oldModelKey)).getTagTreeNode()));
        }
        return changes;
    }

    private void walkNodes(TreeDeltaNode newNode, Map<String, TreeDeltaNode> oldModelMap, List<TreeChange> changes) {
        if (!oldModelMap.containsKey(newNode.getId())) {
            changes.add(new TreeChange().node(newNode.getTagTreeNode()).changeType(TreeChange.ChangeTypeEnum.NEW_NODE).parent(newNode.getParent().getTagTreeNode()));
        } else {
            TreeDeltaNode oldNode = oldModelMap.get(newNode.getId());
            if (!Objects.equals(oldNode.getTagTreeNode().getName(), newNode.getTagTreeNode().getName()) || !Objects.equals(oldNode.getTagTreeNode().getExpanded(), newNode.getTagTreeNode().getExpanded())) {
                changes.add(new TreeChange().node(newNode.getTagTreeNode()).changeType(TreeChange.ChangeTypeEnum.RENAME));
            } else if (newNode.getParent() != null && !newNode.getParent().getId().equals(oldNode.getParent().getId())) {
                changes.add(new TreeChange().node(newNode.getTagTreeNode()).changeType(TreeChange.ChangeTypeEnum.MOVED).parent(newNode.getParent().getTagTreeNode()).parentMovePosition(TagController.getPositionInParent(newNode)));
            }
            boolean orderChanged = false;
            int oldChildSize = oldNode.getTagTreeNode().getChildren() != null ? oldNode.getTagTreeNode().getChildren().size() : 0;
            int newChildSize = newNode.getTagTreeNode().getChildren() != null ? newNode.getTagTreeNode().getChildren().size() : 0;
            ArrayList<String> orderedChildIds = new ArrayList<String>();
            if (oldChildSize == newChildSize) {
                for (int i = 0; i < newChildSize; ++i) {
                    String newChildId = Objects.requireNonNull(newNode.getTagTreeNode().getChildren().get(i).getId()).toString();
                    orderedChildIds.add(newChildId);
                    if (oldNode.getChildren().get(i).getId().equals(newChildId)) continue;
                    orderChanged = true;
                }
            }
            if (orderChanged) {
                changes.add(new TreeChange().node(newNode.getTagTreeNode()).changeType(TreeChange.ChangeTypeEnum.REORDER).parentPositions(orderedChildIds));
            }
        }
        newNode.getChildren().forEach(child -> this.walkNodes((TreeDeltaNode)child, oldModelMap, changes));
    }

    private static int getPositionInParent(TreeDeltaNode newNode) {
        assert (newNode.getParent().getTagTreeNode().getChildren() != null);
        return newNode.getParent().getTagTreeNode().getChildren().indexOf(newNode.getTagTreeNode());
    }

    private void wrapTree(TagTreeNode node, TreeDeltaNode treeDeltaNode, Map<String, TreeDeltaNode> map) {
        treeDeltaNode.setTagTreeNode(node);
        map.put(Objects.requireNonNull(node.getId()).toString(), treeDeltaNode);
        if (node.getChildren() != null) {
            for (TagTreeNode child : node.getChildren()) {
                TreeDeltaNode childDeltaNode = new TreeDeltaNode();
                childDeltaNode.setParent(treeDeltaNode);
                treeDeltaNode.getChildren().add(childDeltaNode);
                this.wrapTree(child, childDeltaNode, map);
            }
        }
    }

    public void getOrCreateSearchNode(String searchText) {
        String tagText = searchText.trim().toLowerCase();
        DefaultTagTreeNode searchNode = null;
        for (int i = 0; i < this.searchResults.getChildCount(); ++i) {
            DefaultTagTreeNode child = this.searchResults.getTagTreeNodeChildAt(i);
            if (!child.getTag().getName().trim().toLowerCase().equals(tagText)) continue;
            searchNode = child;
            break;
        }
        if (searchNode == null) {
            searchNode = new DefaultTagTreeNode(Tag.builder().name(searchText).type(Tag.TagType.searchResult).build());
            this.searchResults.add(searchNode);
            this.tagTreePanel.fireNodeStructureChanged(this.searchResults);
            this.tagTreePanel.expandNode(this.searchResults);
        }
        this.tagTreePanel.selectNode(searchNode);
    }

    private void onRemoveSearchResult() {
        DefaultTagTreeNode selectedNode = this.tagTreePanel.getSelectedNode();
        if (selectedNode != null && selectedNode.getTag().isSearchResult()) {
            this.removeSearchResult(selectedNode);
        }
    }

    private void removeSearchResult(DefaultTagTreeNode tagNode) {
        this.searchResults.remove(tagNode);
        this.tagTreePanel.fireNodeStructureChanged(this.searchResults);
        this.tagTreePanel.expandNode(this.searchResults);
        this.searchService.removeResult(tagNode.getTag().getName());
        this.tagTreePanel.selectNode(this.searchResults);
    }

    private void onRemoveAllSearchResults() {
        this.searchResults.removeAllChildren();
        this.tagTreePanel.fireNodeStructureChanged(this.searchResults);
        this.searchService.removeAllResults();
        this.tagTreePanel.selectNode(this.searchResults);
    }

    @Generated
    public TagController(TagTreePanel tagTreePanel, ClientService clientService, ActionService actionService, I18nService i18n, DocumentService documentService, ErrorController errorController, SettingsService<AppSettings> settingsService, UIUtils uiUtils, SearchService searchService) {
        this.tagTreePanel = tagTreePanel;
        this.clientService = clientService;
        this.actionService = actionService;
        this.i18n = i18n;
        this.documentService = documentService;
        this.errorController = errorController;
        this.settingsService = settingsService;
        this.uiUtils = uiUtils;
        this.searchService = searchService;
    }
}

