/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.controller;

import jakarta.annotation.PostConstruct;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.JDialog;
import javax.swing.JFrame;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.model.RectangleWrapper;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.general.OkCancelDialog;
import net.schembs.solutions.dms.client.model.AppError;
import net.schembs.solutions.dms.client.model.ErrorCode;
import net.schembs.solutions.dms.client.ui.general.error.ErrorPanel;
import net.schembs.solutions.dms.client.ui.general.error.ErrorShowPane;
import net.schembs.solutions.dms.client.ui.general.error.ErrorTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class ErrorController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorController.class);
    private static final String PREF_KEY = "errorDialog.bounds";
    private final I18nService i18n;
    private final ErrorPanel errorPanel;
    private final AppPreferences appPreferences;
    private ErrorTableModel errorTableModel;
    private final List<AppError> errors = new ArrayList<AppError>();
    private final List<ErrorReceivedListener> errorReceivedListeners = new ArrayList<ErrorReceivedListener>();

    @PostConstruct
    public void init() {
        this.errorTableModel = new ErrorTableModel(this.i18n);
        this.errorPanel.setModel(this.errorTableModel);
    }

    public void handleError(ErrorCode errorCode, Throwable t, Object ... params) {
        AppError appError = AppError.builder().errorCode(errorCode).throwable(t).params(params != null ? Arrays.stream(params).toList() : new ArrayList()).build();
        this.errors.add(appError);
        this.errorReceivedListeners.forEach(l -> l.onErrorReceived(appError));
    }

    public void showErrors(JFrame frame) {
        OkCancelDialog dialog = new OkCancelDialog((Window)frame, this.i18n);
        dialog.setTitle(this.i18n.t("error.title", new Object[0]));
        dialog.createUI();
        dialog.setResizable(true);
        this.errorTableModel.updateErrors(this.errors);
        dialog.getContentPane().add((Component)this.errorPanel, "Center");
        dialog.pack();
        this.loadProperties(dialog);
        dialog.setLocationRelativeTo(frame);
        this.errorPanel.getTable().selectRow(0, false);
        dialog.setVisible(true);
        this.storeProperties(dialog);
    }

    private void loadProperties(JDialog dialog) {
        try {
            dialog.setBounds(this.appPreferences.get(PREF_KEY, RectangleWrapper.class).asRectangle());
        }
        catch (Exception e) {
            dialog.setSize(800, 600);
        }
    }

    private void storeProperties(JDialog dialog) {
        this.appPreferences.put(PREF_KEY, new RectangleWrapper(dialog.getBounds()));
    }

    public boolean hasUnviewedErrors() {
        return this.errors.stream().anyMatch(e -> !e.isViewed());
    }

    public <T> Optional<T> findException(Throwable t, Class<T> clazz) {
        if (clazz.isAssignableFrom(t.getClass())) {
            return Optional.of(t);
        }
        if (t.getCause() != null) {
            return this.findException(t.getCause(), clazz);
        }
        return Optional.empty();
    }

    public void showError(JFrame frame, AppError appError) {
        log.error("Error orccured: {}", (Object)appError);
        ErrorShowPane.showErrorWithDetails(frame, appError, this.i18n);
    }

    @Generated
    public ErrorController(I18nService i18n, ErrorPanel errorPanel, AppPreferences appPreferences) {
        this.i18n = i18n;
        this.errorPanel = errorPanel;
        this.appPreferences = appPreferences;
    }

    @Generated
    public List<AppError> getErrors() {
        return this.errors;
    }

    @Generated
    public List<ErrorReceivedListener> getErrorReceivedListeners() {
        return this.errorReceivedListeners;
    }

    public static interface ErrorReceivedListener {
        public void onErrorReceived(AppError var1);
    }
}

