/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.controller;

import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.UIUtils;
import net.schembs.solutions.dms.client.controller.ErrorController;
import net.schembs.solutions.dms.client.exception.DocumentUploadException;
import net.schembs.solutions.dms.client.model.Actions;
import net.schembs.solutions.dms.client.model.ErrorCode;
import net.schembs.solutions.dms.client.service.DocumentService;
import net.schembs.solutions.dms.client.ui.general.FileDialogs;
import net.schembs.solutions.dms.client.ui.general.document.drop.DocumentUploadListener;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropPreview;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropRowUploadListener;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropStatus;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropTableModel;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropTablePanel;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropTableRow;
import net.schembs.solutions.dms.client.ui.osspecific.OSSpecificFileDialogs;
import net.schembs.solutions.dms.supportedfiles.FileDescriptionDetector;
import net.schembs.solutions.dms.supportedfiles.FileTypeDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class DropDocumentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DropDocumentController.class);
    private final DropTablePanel dropTablePanel;
    private final DocumentService documentService;
    private final ActionService actionService;
    private final DropPreview dropPreview;
    private final FileTypeDetector fileTypeDetector;
    private final I18nService i18n;
    private final FileDialogs fileDialogs;
    private final FileDescriptionDetector fileDescriptionDetector;
    private final UIUtils uiUtils;
    private final List<DocumentUploadListener> documentUploadListeners = new ArrayList<DocumentUploadListener>();
    private final ErrorController errorController;
    private DropTableModel dropTableModel;
    private int[] selectedModelRowIndices;
    private int popupMenuActionModelRowIndex = -1;

    @PostConstruct
    public void init() {
        this.configureActions();
        this.dropTableModel = new DropTableModel(this.i18n);
        this.dropTablePanel.getDropListeners().add(this::onDrop);
        this.dropTablePanel.setModel(this.dropTableModel);
        this.dropTablePanel.getTable().getListSelectionListeners().add(this::onSelectDropped);
        this.dropTablePanel.setRowUploadListener(new DropRowUploadListener(){

            @Override
            public void onRowUploadPressed(int row) {
                DropDocumentController.this.onRowUploadPressed(row);
            }

            @Override
            public void onRowUploadCancelled(int row) {
                DropDocumentController.this.onRowUploadCancelled(row);
            }
        });
        this.dropTablePanel.getTable().setTablePopupProvider(this::getPopupForTable);
    }

    private JPopupMenu getPopupForTable(int popupMenuActionModelRowIndex, int[] selectedModelRowIndices) {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem(this.actionService.getAction(Actions.documentNew)));
        int uploadableRows = 0;
        for (int i = 0; i < selectedModelRowIndices.length; ++i) {
            if (!this.isUploadable((DropTableRow)this.dropTableModel.getRows().get(selectedModelRowIndices[i]))) continue;
            ++uploadableRows;
        }
        int allUploadable = 0;
        for (int i = 0; i < this.dropTableModel.getRows().size(); ++i) {
            if (!this.isUploadable((DropTableRow)this.dropTableModel.getRows().get(i))) continue;
            ++allUploadable;
        }
        if (uploadableRows > 0) {
            if (selectedModelRowIndices.length == 1) {
                popup.add(new JMenuItem(this.actionService.getAction(Actions.documentUpload)));
            } else {
                popup.add(this.uiUtils.getDelegateMenuItem(Actions.documentUpload, Actions.documentsUpload, uploadableRows));
            }
        }
        if (allUploadable > 0) {
            popup.add(this.uiUtils.getDelegateMenuItem(Actions.documentsUploadAll, Actions.documentsUploadAllDetail, allUploadable, this.dropTableModel.getRows().size()));
        }
        if (popup.getComponentCount() > 0) {
            popup.addSeparator();
        }
        if (selectedModelRowIndices.length == 1) {
            popup.add(new JMenuItem(this.actionService.getAction(Actions.dropTableRemoveRow)));
        } else {
            popup.add(this.uiUtils.getDelegateMenuItem(Actions.dropTableRemoveRow, Actions.dropTableRemoveRows, selectedModelRowIndices.length));
        }
        popup.add(this.uiUtils.getDelegateMenuItem(Actions.dropTableRemoveAllRows, Actions.dropTableRemoveAllRows, this.dropTableModel.getRows().size()));
        return popup;
    }

    private boolean isUploadable(DropTableRow row) {
        return row.getStatus() == DropStatus.dropped;
    }

    private void onSelectDropped(int[] rowIndices) {
        this.selectedModelRowIndices = rowIndices;
        this.popupMenuActionModelRowIndex = -1;
        DropTableRow row = DropTableRow.builder().type(FileTypeDetector.FileType.unknown).build();
        if (rowIndices != null && rowIndices.length == 1) {
            int rowIndex = rowIndices[0];
            row = (DropTableRow)this.dropTableModel.getRows().get(rowIndex);
        }
        this.dropPreview.loadDocument(row.getType() != FileTypeDetector.FileType.unknown ? row.getFile() : null, 1);
        this.dropPreview.revalidate();
        this.dropPreview.repaint();
    }

    private void onDrop(List<File> files) {
        Integer firstInserted = null;
        for (File file : files) {
            this.addDroppedFile(file);
            if (firstInserted != null) continue;
            firstInserted = this.dropTableModel.getRows().size() - 1;
        }
        this.dropTableModel.fireTableDataChanged();
        if (firstInserted != null) {
            this.dropTablePanel.selectRows(new int[]{0});
        }
    }

    private void addDroppedFile(File file) {
        FileTypeDetector.FileType fileType = this.fileTypeDetector.detectFileType(file);
        String description = fileType != FileTypeDetector.FileType.unknown ? this.fileDescriptionDetector.getFileDescription(file) : null;
        this.dropTableModel.getRows().add(DropTableRow.builder().file(file).type(fileType).status(fileType != FileTypeDetector.FileType.unknown ? DropStatus.dropped : DropStatus.noUpload).description(description).build());
    }

    private void onRowUploadPressed(int modelRowIndex) {
        DropTableRow row = (DropTableRow)this.dropTableModel.getRows().get(modelRowIndex);
        this.onUploadRow(row);
    }

    private String getRowDescription(File file, String description) {
        return description != null && !description.trim().isEmpty() ? description : this.fileDescriptionDetector.getFileDescription(file);
    }

    private void onRowUploadsCancelled(int ... rowIndices) {
        Arrays.sort(rowIndices);
        for (int i = rowIndices.length - 1; i >= 0; --i) {
            this.dropTableModel.getRows().remove(rowIndices[i]);
        }
        this.dropTableModel.fireTableDataChanged();
        if (!this.dropTableModel.getRows().isEmpty()) {
            this.dropTablePanel.selectRows(new int[]{0});
        }
    }

    private void onRowUploadCancelled(int rowIndex) {
        this.dropTableModel.getRows().remove(rowIndex);
        this.dropTableModel.fireTableDataChanged();
        if (!this.dropTableModel.getRows().isEmpty()) {
            this.dropTablePanel.selectRows(new int[]{0});
        }
    }

    private void configureActions() {
        this.actionService.getAction(Actions.documentNew).setActionListener(e -> this.onNewDocument());
        this.actionService.getAction(Actions.documentUpload).setActionListener(e -> this.onUpload());
        this.actionService.getAction(Actions.documentsUploadAll).setActionListener(e -> this.onUploadAll());
        this.actionService.getAction(Actions.dropTableRemoveRow).setActionListener(e -> this.onRemoveRow());
        this.actionService.getAction(Actions.dropTableRemoveAllRows).setActionListener(e -> this.onRemoveAllRows());
    }

    private void onRemoveAllRows() {
        this.dropTableModel.getRows().clear();
        this.dropTableModel.fireTableDataChanged();
    }

    private void onRemoveRow() {
        if (this.selectedModelRowIndices.length > 0) {
            this.onRowUploadsCancelled(this.selectedModelRowIndices);
        }
    }

    private void onUpload() {
        if (this.selectedModelRowIndices != null && this.selectedModelRowIndices.length > 1) {
            List<DropTableRow> rows = Arrays.stream(this.selectedModelRowIndices).mapToObj(i -> (DropTableRow)this.dropTableModel.getRows().get(i)).toList();
            rows.forEach(this::onUploadRow);
        } else {
            this.getRowDataForPopupActionOrSelection().ifPresent(this::onUploadRow);
        }
    }

    private void onUploadAll() {
        this.dropTableModel.getRows().forEach(row -> {
            if (this.isUploadable((DropTableRow)row)) {
                this.onUploadRow((DropTableRow)row);
            }
        });
    }

    private void onUploadRow(DropTableRow row) {
        log.info("Row: {}", (Object)row);
        row.setStatus(DropStatus.uploading);
        int[] tableRowIndices = this.dropTablePanel.getSelectedRows();
        this.dropTableModel.fireTableDataChanged();
        this.dropTablePanel.selectRows(tableRowIndices);
        ((CompletableFuture)this.documentService.uploadDocument(row.getFile().getName(), this.getRowDescription(row.getFile(), row.getDescription()), row.getFile()).thenAccept(id -> {
            row.setStatus(DropStatus.uploaded);
            this.dropTableModel.fireTableDataChanged();
            this.dropTablePanel.selectRows(tableRowIndices);
            this.documentUploadListeners.forEach(l -> l.onDocumentUploaded((Long)id));
        })).exceptionally(t -> {
            this.errorController.findException((Throwable)t, DocumentUploadException.class).ifPresentOrElse(documentUploadException -> this.errorController.handleError(ErrorCode.documentUploadFailed, (Throwable)documentUploadException, documentUploadException.getName()), () -> this.errorController.handleError(ErrorCode.documentUploadFailed, (Throwable)t, new Object[0]));
            row.setStatus(DropStatus.failed);
            this.dropTableModel.fireTableDataChanged();
            this.dropTablePanel.selectRows(tableRowIndices);
            return null;
        });
    }

    private void onNewDocument() {
        File[] files = this.fileDialogs.showOpenDialog(this.dropTablePanel, true, List.of(OSSpecificFileDialogs.Extension.builder().extension("pdf").description(this.i18n.t("fileDialog.pdfFilter.title", new Object[0])).build()));
        if (files != null && files.length > 0) {
            this.onDrop(Arrays.asList(files));
        }
    }

    private Optional<DropTableRow> getRowDataForPopupActionOrSelection() {
        DropTableRow document = null;
        if (this.popupMenuActionModelRowIndex > -1) {
            document = (DropTableRow)this.dropTableModel.getRows().get(this.popupMenuActionModelRowIndex);
        } else if (this.selectedModelRowIndices != null && this.selectedModelRowIndices.length == 1) {
            document = (DropTableRow)this.dropTableModel.getRows().get(this.selectedModelRowIndices[0]);
        }
        return Optional.ofNullable(document);
    }

    @Generated
    public DropDocumentController(DropTablePanel dropTablePanel, DocumentService documentService, ActionService actionService, DropPreview dropPreview, FileTypeDetector fileTypeDetector, I18nService i18n, FileDialogs fileDialogs, FileDescriptionDetector fileDescriptionDetector, UIUtils uiUtils, ErrorController errorController) {
        this.dropTablePanel = dropTablePanel;
        this.documentService = documentService;
        this.actionService = actionService;
        this.dropPreview = dropPreview;
        this.fileTypeDetector = fileTypeDetector;
        this.i18n = i18n;
        this.fileDialogs = fileDialogs;
        this.fileDescriptionDetector = fileDescriptionDetector;
        this.uiUtils = uiUtils;
        this.errorController = errorController;
    }

    @Generated
    public List<DocumentUploadListener> getDocumentUploadListeners() {
        return this.documentUploadListeners;
    }
}

