/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.controller;

import jakarta.annotation.PostConstruct;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.model.RectangleWrapper;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.service.AppAction;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.ui.UIUtils;
import net.schembs.solutions.desktopclient.ui.general.OkCancelDialog;
import net.schembs.solutions.dms.client.controller.AnalyzedDocumentLoader;
import net.schembs.solutions.dms.client.controller.DropDocumentController;
import net.schembs.solutions.dms.client.controller.ErrorController;
import net.schembs.solutions.dms.client.exception.DocumentDeleteFailedException;
import net.schembs.solutions.dms.client.exception.DocumentLoadAnaylzedContentException;
import net.schembs.solutions.dms.client.exception.DocumentLoadContentException;
import net.schembs.solutions.dms.client.exception.DocumentLoadListForTagException;
import net.schembs.solutions.dms.client.exception.DocumentSearchFailedException;
import net.schembs.solutions.dms.client.exception.DocumentSearchResultEmptyException;
import net.schembs.solutions.dms.client.exception.DocumentUpdateFailedException;
import net.schembs.solutions.dms.client.exception.DocumentsExportException;
import net.schembs.solutions.dms.client.model.Actions;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.model.DmsDocument;
import net.schembs.solutions.dms.client.model.DocumentAttribute;
import net.schembs.solutions.dms.client.model.DocumentWord;
import net.schembs.solutions.dms.client.model.ErrorCode;
import net.schembs.solutions.dms.client.model.Tag;
import net.schembs.solutions.dms.client.model.TaggedDMSDocuments;
import net.schembs.solutions.dms.client.service.DocumentFilenameService;
import net.schembs.solutions.dms.client.service.DocumentService;
import net.schembs.solutions.dms.client.service.ExportService;
import net.schembs.solutions.dms.client.service.LocalStorageService;
import net.schembs.solutions.dms.client.service.SearchService;
import net.schembs.solutions.dms.client.ui.general.FileDialogs;
import net.schembs.solutions.dms.client.ui.general.document.DocumentPreviewPanel;
import net.schembs.solutions.dms.client.ui.general.document.edit.DocumentEditPanel;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentSelectionListener;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentTableDragDropListener;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentTableModel;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentTablePanel;
import net.schembs.solutions.dms.client.ui.general.document.list.targetmenu.TargetMenu;
import net.schembs.solutions.dms.client.ui.general.document.list.targetmenu.TargetMenuItem;
import net.schembs.solutions.dms.client.ui.general.document.pdfedit.PDFEditPanel;
import net.schembs.solutions.dms.client.ui.general.document.view.DocumentAttributesPanel;
import net.schembs.solutions.dms.client.ui.general.document.view.DocumentAttributesTableModel;
import net.schembs.solutions.dms.client.ui.general.tag.tree.DefaultTagTreeNode;
import net.schembs.solutions.dms.client.ui.general.tag.tree.TagTreePanel;
import net.schembs.solutions.dms.client.ui.osspecific.OSSpecificFileDialogs;
import net.schembs.solutions.dms.security.service.AuthService;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class DocumentController
implements DocumentTableDragDropListener,
AnalyzedDocumentLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentController.class);
    private final DocumentTablePanel documentTablePanel;
    private final TagTreePanel tagTreePanel;
    private final DocumentService documentService;
    private final I18nService i18n;
    private final DropDocumentController dropDocumentController;
    private final LocalStorageService localStorageService;
    private final DocumentPreviewPanel documentPreviewPanel;
    private final ErrorController errorController;
    private final ActionService actionService;
    private final UIUtils uiUtils;
    private final FileDialogs fileDialogs;
    private final ExportService exportService;
    private final SettingsService<AppSettings> settingsService;
    private final AuthService authService;
    private final DocumentEditPanel documentEditPanel;
    private final DocumentFilenameService documentFilenameService;
    private final PDFEditPanel pdfEditPanel;
    private final List<DocumentSelectionListener> documentSelectionListeners = new ArrayList<DocumentSelectionListener>();
    private final DocumentAttributesPanel documentAttributesPanel;
    private final SearchService searchService;
    private final AppPreferences appPreferences;
    private DocumentTableModel documentTableModel;
    private Tag currentTag;
    private int[] selectedModelRowIndices;
    private int popupMenuActionModelRowIndex = -1;
    private DmsDocument currentDocument;
    private int currentSelectedDocumentPage;
    private DocumentAttributesTableModel attributesTableModel;
    private DocumentAttribute currentDocumentAttribute;
    private List<String> existingDescriptions;
    private int currentRowIndex;
    private String currentTagPath;

    @PostConstruct
    public void init() {
        this.configureActions();
        this.documentTableModel = new DocumentTableModel(this.i18n);
        this.documentTablePanel.setModel(this.documentTableModel);
        this.attributesTableModel = new DocumentAttributesTableModel(this.i18n);
        this.documentAttributesPanel.setModel(this.attributesTableModel);
        this.documentAttributesPanel.getSelectionListeners().add(this::onSelectAttribute);
        this.documentAttributesPanel.getClickListeners().add(this::onAttributeDoubleClicked);
        this.documentTablePanel.getDocumentsPastedListeners().add(this::onDocumentsPasted);
        this.documentTablePanel.getTable().getListSelectionListeners().add(this::onSelectDocuments);
        this.documentTablePanel.getTable().getClickListeners().add(this::onDocumentDoubleClicked);
        this.documentTablePanel.getTable().setTablePopupProvider(this::getPopupForTable);
        this.tagTreePanel.getSelectionListeners().add(this::onSelectedTag);
        this.tagTreePanel.getDocumentsPastedListeners().add(this::onDocumentsPasted);
        this.dropDocumentController.getDocumentUploadListeners().add(this::onDocumentUploaded);
        this.documentTablePanel.getDragDropListeners().add(this);
        this.documentPreviewPanel.getPageSelectionListeners().add(this::onPageSelected);
        this.documentEditPanel.setContentLoader(this);
    }

    private void configureActions() {
        this.actionService.getAction(Actions.documentMoveToTrash).setActionListener(l -> this.onMoveDocumentToTrash());
        this.actionService.getAction(Actions.documentRemoveFromTag).setActionListener(l -> this.onRemoveDocumentFromTag());
        this.actionService.getAction(Actions.documentExport).setActionListener(l -> this.onExportDocument());
        this.actionService.getAction(Actions.documentDelete).setActionListener(l -> this.onDocumentDelete());
        this.actionService.getAction(Actions.documentPrint).setActionListener(l -> this.onPreparePrint());
        this.actionService.getAction(Actions.documentEdit).setActionListener(l -> this.onEditDocument());
        this.actionService.getAction(Actions.documentsCreateZip).setActionListener(l -> this.onZipDocuments());
        this.actionService.getAction(Actions.documentPdfEdit).setActionListener(l -> this.onShowEditPdf());
        this.actionService.getAction(Actions.documentMoveToTag).setActionListener(l -> this.onMoveDocument(l));
    }

    private void onSelectDocuments(int[] rowIndices) {
        this.selectedModelRowIndices = rowIndices;
        this.popupMenuActionModelRowIndex = -1;
        if (rowIndices != null && rowIndices.length == 1) {
            int rowIndex = rowIndices[0];
            DmsDocument document = (DmsDocument)this.documentTableModel.getRows().get(rowIndex);
            log.info("Selected document {} from index {}", (Object)document, (Object)rowIndex);
            this.currentRowIndex = rowIndex;
            this.loadDocumentContent(document);
            this.loadDocumentTags(document);
            this.onSelectSingleDocument(document);
        } else {
            this.currentRowIndex = -1;
            this.onDocumentContentLoaded(null);
            this.onDocumentTagsLoaded(null, null);
            this.onSelectSingleDocument(null);
        }
        this.setDocumentSelectCountLabel(rowIndices != null ? rowIndices.length : 0);
    }

    private void loadDocumentTags(DmsDocument document) {
        ((CompletableFuture)this.documentService.getDocumentTags(document).thenAccept(tags -> this.onDocumentTagsLoaded(document, (List<String>)tags))).exceptionally(t -> this.onDocumentTagsLoadFailed(document));
    }

    private void onDocumentTagsLoaded(DmsDocument document, List<String> tags) {
        this.currentDocumentAttribute = null;
        this.attributesTableModel.setDocument(document, this.currentTag != null && !this.currentTag.isQuery() && !this.currentTag.isSearchResult() ? this.currentTagPath : null, tags);
    }

    private Void onDocumentTagsLoadFailed(DmsDocument document) {
        this.onDocumentTagsLoaded(document, null);
        return null;
    }

    private void onSelectSingleDocument(DmsDocument document) {
        this.documentSelectionListeners.forEach(listener -> listener.onDocumentSelected(document));
    }

    private void onDocumentUploaded(Long documentId) {
        if (this.currentTag != null && this.currentTag.isInbox()) {
            this.loadDocumentsForTag(this.currentTag, documentId);
        }
    }

    private void onSelectedTag(Tag tag, String tagPath) {
        log.info("Selected tag: {}", (Object)tag);
        this.currentTag = tag;
        this.currentTagPath = tagPath;
        if (tag == null || !tag.isSearchResult()) {
            this.loadDocumentsForTag(tag, null);
        } else {
            this.loadSearchResultForTag(tag);
        }
    }

    private void loadDocumentsForTag(Tag tag, Long documentIdToSelect) {
        if (tag != null && this.authService.isAuthenticated()) {
            ((CompletableFuture)this.documentService.loadDocumentsForTag(tag).thenAccept(documents -> this.onDocumentListLoaded((List<DmsDocument>)documents, documentIdToSelect, false))).exceptionally(this::onFailedDocumentList);
        } else {
            this.documentTableModel.getRows().clear();
            this.documentTableModel.fireTableDataChanged();
            this.setDocumentCountLabel(0);
        }
    }

    private void onDocumentListLoaded(List<DmsDocument> documents, Long documentIdToSelect, boolean withSearchFields) {
        this.documentTableModel.getRows().clear();
        this.documentTableModel.getRows().addAll(documents);
        this.documentTablePanel.updateTableTypeForSearchResults(withSearchFields);
        this.documentTableModel.fireTableDataChanged();
        int rowToSelect = this.indexOfRowWithId(documentIdToSelect);
        if (rowToSelect == -1) {
            rowToSelect = 0;
        }
        this.documentTablePanel.selectRow(rowToSelect);
        this.setDocumentCountLabel(documents.size());
    }

    public void setDocumentCountLabel(int count) {
        this.documentTablePanel.getDocumentCountLabel().setText(this.i18n.t("documentTable.documents.count", count));
    }

    public void setDocumentSelectCountLabel(int count) {
        this.documentTablePanel.getDocumentSelectedCountLabel().setText(this.i18n.t("documentTable.documents.selected.count", count));
    }

    private int indexOfRowWithId(Long documentIdToSelect) {
        for (int i = 0; i < this.documentTableModel.getRows().size(); ++i) {
            if (!((DmsDocument)this.documentTableModel.getRows().get(i)).getId().equals(documentIdToSelect)) continue;
            return i;
        }
        return -1;
    }

    private Void onFailedDocumentList(Throwable t) {
        this.errorController.findException(t, DocumentLoadListForTagException.class).ifPresentOrElse(documentLoadListForTagException -> this.errorController.handleError(ErrorCode.documentLoadListFailed, (Throwable)documentLoadListForTagException, documentLoadListForTagException.getTag().getName()), () -> this.errorController.handleError(ErrorCode.documentLoadListFailed, t, new Object[0]));
        this.documentTableModel.getRows().clear();
        this.documentTableModel.fireTableDataChanged();
        this.documentTablePanel.selectRow(-1);
        return null;
    }

    private void loadDocumentContent(DmsDocument document) {
        this.currentSelectedDocumentPage = 0;
        ((CompletableFuture)this.documentService.loadDocument(document).thenAccept(this::onDocumentContentLoaded)).exceptionally(this::onFailedDocumentContentLoad);
    }

    private void onDocumentContentLoaded(DmsDocument document) {
        log.info("Load document: {}", (Object)document);
        this.currentDocument = document;
        this.documentPreviewPanel.loadDocument(document != null ? this.localStorageService.getTempFilePath(document.getStorageId()).toFile() : null, this.currentSelectedDocumentPage);
        this.documentPreviewPanel.revalidate();
        this.documentPreviewPanel.repaint();
    }

    private Void onFailedDocumentContentLoad(Throwable t) {
        this.errorController.findException(t, DocumentLoadContentException.class).ifPresentOrElse(documentLoadContentException -> this.errorController.handleError(ErrorCode.documentLoadContentFailed, (Throwable)documentLoadContentException, documentLoadContentException.getDocument().getName()), () -> this.errorController.handleError(ErrorCode.documentLoadContentFailed, t, new Object[0]));
        return null;
    }

    @Override
    public void onDragDropStart(TaggedDMSDocuments taggedDMSDocuments) {
        taggedDMSDocuments.setTagToRemove(this.currentTag);
    }

    @Override
    public void onDragDropEnd(TaggedDMSDocuments taggedDMSDocuments, int action) {
        switch (action) {
            case 2: {
                this.switchTagForDocuments(taggedDMSDocuments);
                break;
            }
            case 1: {
                this.addTagToDocuments(taggedDMSDocuments);
                break;
            }
        }
    }

    private void addTagToDocuments(TaggedDMSDocuments taggedDMSDocuments) {
        if (taggedDMSDocuments.getTagToAdd() != taggedDMSDocuments.getTagToRemove()) {
            if (!taggedDMSDocuments.getTagToAdd().isTrash()) {
                if (taggedDMSDocuments.getTagToRemove() == null || !taggedDMSDocuments.getTagToRemove().isTrash()) {
                    this.documentService.addTagToDocuments(taggedDMSDocuments.getDocuments(), taggedDMSDocuments.getTagToAdd()).thenAccept(this::afterTagModified);
                } else {
                    this.documentService.switchTagForDocuments(taggedDMSDocuments.getDocuments(), taggedDMSDocuments.getTagToAdd(), taggedDMSDocuments.getTagToRemove()).thenAccept(this::afterTagModified);
                }
            } else {
                this.documentService.moveToTrashTagForDocuments(taggedDMSDocuments.getDocuments()).thenAccept(this::afterTagModified);
            }
        }
    }

    private void switchTagForDocuments(TaggedDMSDocuments taggedDMSDocuments) {
        if (taggedDMSDocuments.getTagToAdd() != taggedDMSDocuments.getTagToRemove()) {
            if (!taggedDMSDocuments.getTagToAdd().isTrash()) {
                this.documentService.switchTagForDocuments(taggedDMSDocuments.getDocuments(), taggedDMSDocuments.getTagToAdd(), taggedDMSDocuments.getTagToRemove()).thenAccept(this::afterTagModified);
            } else {
                this.documentService.moveToTrashTagForDocuments(taggedDMSDocuments.getDocuments()).thenAccept(this::afterTagModified);
            }
        }
    }

    private void afterTagModified(Void unused) {
        this.onSelectedTag(this.currentTag, this.currentTagPath);
    }

    public void onShowDocumentView() {
        log.info("Showing documents");
    }

    private JPopupMenu getPopupForTable(int popupMenuActionModelRowIndex, int[] selectedModelRowIndices) {
        this.popupMenuActionModelRowIndex = popupMenuActionModelRowIndex;
        JPopupMenu popup = new JPopupMenu();
        if (this.currentTag.isTrash()) {
            if (selectedModelRowIndices.length == 1) {
                popup.add(new JMenuItem(this.actionService.getAction(Actions.documentDelete)));
            } else {
                popup.add(this.uiUtils.getDelegateMenuItem(Actions.documentDelete, Actions.documentsDelete, selectedModelRowIndices.length));
            }
        } else if (this.currentTag.isSearchResultsContainer()) {
            popup.add(new JMenuItem(this.actionService.getAction(Actions.searchRemoveAllResults)));
        } else if (selectedModelRowIndices.length == 1) {
            popup.add(new JMenuItem(this.actionService.getAction(Actions.documentEdit)));
            popup.add(new JMenuItem(this.actionService.getAction(Actions.documentExport)));
            popup.add(new JMenuItem(this.actionService.getAction(Actions.documentPrint)));
            popup.add(this.createMoveMenu(popup, this.actionService.getAction(Actions.documentMoveToTag), null));
            if (!(this.currentTag.isRoot() || this.currentTag.isSearchResult() || this.currentTag.isQuery())) {
                popup.add(this.uiUtils.getDelegateMenuItem(Actions.documentRemoveFromTag, Actions.documentRemoveFromTag, this.currentTag.getName()));
            }
            popup.add(new JMenuItem(this.actionService.getAction(Actions.documentMoveToTrash)));
        } else {
            popup.add(this.uiUtils.getDelegateMenuItem(Actions.documentExport, Actions.documentsExport, selectedModelRowIndices.length));
            popup.add(this.uiUtils.getDelegateMenuItem(Actions.documentsCreateZip, Actions.documentsCreateZip, selectedModelRowIndices.length));
            popup.add(this.createMoveMenu(popup, this.actionService.getAction(Actions.documentMoveToTag), this.i18n.t(Actions.documentsMoveToTag.toString(), selectedModelRowIndices.length)));
            if (!(this.currentTag.isRoot() || this.currentTag.isSearchResult() || this.currentTag.isQuery())) {
                popup.add(this.uiUtils.getDelegateMenuItem(Actions.documentRemoveFromTag, Actions.documentsRemoveFromTag, selectedModelRowIndices.length, this.currentTag.getName()));
            }
            popup.add(this.uiUtils.getDelegateMenuItem(Actions.documentMoveToTrash, Actions.documentsMoveToTrash, selectedModelRowIndices.length));
        }
        return popup;
    }

    private JMenu createMoveMenu(JPopupMenu popupMenu, AppAction action, String text) {
        DefaultTagTreeNode child;
        JMenu menu = new JMenu(action);
        if (text != null) {
            menu.setText(text);
        }
        menu.add(TargetMenu.hasNormalChildren(child = this.tagTreePanel.getRootNode().getTagTreeNodeChildAt(0)) ? new TargetMenu(popupMenu, child, this.actionService.getAction(Actions.documentMoveToTag)) : new TargetMenuItem(child, this.actionService.getAction(Actions.documentMoveToTag)));
        return menu;
    }

    private void onMoveDocument(ActionEvent l) {
        if (this.currentTag != null) {
            if (this.selectedModelRowIndices != null && this.selectedModelRowIndices.length > 1) {
                List<DmsDocument> documents = Arrays.stream(this.selectedModelRowIndices).mapToObj(i -> (DmsDocument)this.documentTableModel.getRows().get(i)).toList();
                this.documentService.switchTagForDocuments(documents, Tag.builder().id(l.getActionCommand()).build(), this.currentTag).thenAccept(this::afterTagModified);
            } else {
                this.getDocumentForPopupActionOrSelection().ifPresent(document -> this.documentService.switchTagForDocuments(List.of(document), Tag.builder().id(l.getActionCommand()).build(), this.currentTag).thenAccept(this::afterTagModified));
            }
        }
        log.info("Move document(s) to {}", (Object)l.getActionCommand());
    }

    private void onMoveDocumentToTrash() {
        if (this.currentTag != null && !this.currentTag.isTrash()) {
            if (this.selectedModelRowIndices != null && this.selectedModelRowIndices.length > 1) {
                List<DmsDocument> documents = Arrays.stream(this.selectedModelRowIndices).mapToObj(i -> (DmsDocument)this.documentTableModel.getRows().get(i)).toList();
                this.documentService.moveToTrashTagForDocuments(documents).thenAccept(this::afterTagModified);
            } else {
                this.getDocumentForPopupActionOrSelection().ifPresent(document -> this.documentService.moveToTrashTagForDocuments(List.of(document)).thenAccept(this::afterTagModified));
            }
        }
    }

    private void onRemoveDocumentFromTag() {
        if (this.selectedModelRowIndices != null && this.selectedModelRowIndices.length > 1) {
            List<DmsDocument> documents = Arrays.stream(this.selectedModelRowIndices).mapToObj(i -> (DmsDocument)this.documentTableModel.getRows().get(i)).toList();
            this.documentService.removeDocumentsFromTag(documents, this.currentTag).thenAccept(this::afterTagModified);
        } else if (this.popupMenuActionModelRowIndex > -1 && this.currentTag != null) {
            DmsDocument document = (DmsDocument)this.documentTableModel.getRows().get(this.popupMenuActionModelRowIndex);
            this.documentService.removeDocumentsFromTag(List.of(document), this.currentTag).thenAccept(this::afterTagModified);
        }
    }

    private void onExportDocument() {
        if (this.selectedModelRowIndices != null && this.selectedModelRowIndices.length > 1) {
            List<DmsDocument> documents = Arrays.stream(this.selectedModelRowIndices).mapToObj(i -> (DmsDocument)this.documentTableModel.getRows().get(i)).toList();
            File basisFolder = this.fileDialogs.showFolderDialog(this.documentTablePanel, this.i18n);
            if (basisFolder != null) {
                this.exportDocuments(basisFolder, documents);
            }
        } else {
            this.getDocumentForPopupActionOrSelection().ifPresent(document -> {
                File f = this.fileDialogs.showSaveDialog(this.documentTablePanel, this.documentFilenameService.getFilenameForDescription((DmsDocument)document), List.of(OSSpecificFileDialogs.Extension.builder().extension("pdf").description(this.i18n.t("fileDialog.pdfFilter.title", new Object[0])).build()));
                if (f != null) {
                    this.exportDocument((DmsDocument)document, f);
                }
            });
        }
    }

    private void exportDocument(DmsDocument document, File f) {
        ((CompletableFuture)this.exportService.exportDocument(f, document).thenAccept(this::onExportedDocument)).exceptionally(this::onFailedExportDocument);
    }

    private void onExportedDocument(DmsDocument document) {
        JOptionPane.showMessageDialog(this.uiUtils.findMainFrame(this.documentTablePanel), this.i18n.t("document.export.finished", new Object[0]));
    }

    private Void onFailedExportDocument(Throwable t) {
        this.errorController.handleError(ErrorCode.documentExportFailed, t, new Object[0]);
        return null;
    }

    private void exportDocuments(File basisFolder, List<DmsDocument> documents) {
        ((CompletableFuture)this.exportService.exportDocuments(basisFolder, documents).thenAccept(this::onExportedDocuments)).exceptionally(this::onFailedExportDocuments);
    }

    private void onExportedDocuments(Void unused) {
        JOptionPane.showMessageDialog(this.uiUtils.findMainFrame(this.documentTablePanel), this.i18n.t("documents.export.finished", new Object[0]));
    }

    private Void onFailedExportDocuments(Throwable t) {
        this.errorController.findException(t, DocumentsExportException.class).ifPresentOrElse(documentsExportException -> this.errorController.handleError(ErrorCode.documentExportsFailed, (Throwable)documentsExportException, documentsExportException.getFailedDocuments().stream().map(DmsDocument::getId).map(Object::toString).collect(Collectors.joining(", "))), () -> this.errorController.handleError(ErrorCode.documentExportsFailed, t, new Object[0]));
        return null;
    }

    private void onZipDocuments() {
        File f;
        if (this.selectedModelRowIndices != null && this.selectedModelRowIndices.length > 1 && (f = this.fileDialogs.showSaveDialog(this.documentTablePanel, this.currentTag.getName() + ".zip", List.of(OSSpecificFileDialogs.Extension.builder().extension("zip").description(this.i18n.t("fileDialog.zipFilter.title", new Object[0])).build()))) != null) {
            List<DmsDocument> documents = Arrays.stream(this.selectedModelRowIndices).mapToObj(i -> (DmsDocument)this.documentTableModel.getRows().get(i)).toList();
            ((CompletableFuture)this.exportService.createZip(f, documents).thenAccept(this::onExportedZip)).exceptionally(this::onFailedExportAsZip);
        }
    }

    private void onExportedZip(Void unused) {
        JOptionPane.showMessageDialog(this.uiUtils.findMainFrame(this.documentTablePanel), this.i18n.t("documents.export.zip.finished", new Object[0]));
    }

    private Void onFailedExportAsZip(Throwable t) {
        this.errorController.handleError(ErrorCode.documentExportFailed, t, new Object[0]);
        return null;
    }

    private void onDocumentDelete() {
        if (this.selectedModelRowIndices != null && this.selectedModelRowIndices.length > 1) {
            List<DmsDocument> documents = Arrays.stream(this.selectedModelRowIndices).mapToObj(i -> (DmsDocument)this.documentTableModel.getRows().get(i)).toList();
            if (!Boolean.FALSE.equals(this.settingsService.getAppSettings().getApp().getConfirmDeleteDocument()) && JOptionPane.showConfirmDialog(this.uiUtils.findMainFrame(this.documentTablePanel), this.i18n.t("confirm.delete.documents", documents.size()), this.i18n.t("confirm.title", new Object[0]), 0) != 0) {
                return;
            }
            ((CompletableFuture)this.documentService.deleteDocument(documents).thenAccept(this::afterTagModified)).exceptionally(this::onFailedDocumentDelete);
        } else {
            this.getDocumentForPopupActionOrSelection().ifPresent(document -> {
                if (!Boolean.FALSE.equals(this.settingsService.getAppSettings().getApp().getConfirmDeleteDocument()) && JOptionPane.showConfirmDialog(this.uiUtils.findMainFrame(this.documentTablePanel), this.i18n.t("confirm.delete.document", document.getDescription()), this.i18n.t("confirm.title", new Object[0]), 0) != 0) {
                    return;
                }
                ((CompletableFuture)this.documentService.deleteDocument(List.of(document)).thenAccept(this::afterTagModified)).exceptionally(this::onFailedDocumentDelete);
            });
        }
    }

    private Void onFailedDocumentDelete(Throwable t) {
        this.errorController.findException(t, DocumentDeleteFailedException.class).ifPresentOrElse(documentDeleteFailedException -> this.errorController.handleError(ErrorCode.documentDeleteFailed, (Throwable)documentDeleteFailedException, documentDeleteFailedException.getDocument().getName()), () -> this.errorController.handleError(ErrorCode.documentDeleteFailed, t, new Object[0]));
        return null;
    }

    private void onDocumentsPasted(TaggedDMSDocuments taggedDMSDocuments) {
        if (this.currentTag != null) {
            List<Long> existingIds = this.documentTableModel.getRows().stream().map(DmsDocument::getId).toList();
            List<DmsDocument> documentsToTransfer = taggedDMSDocuments.getDocuments().stream().filter(d -> !existingIds.contains(d.getId())).toList();
            taggedDMSDocuments.setTagToAdd(this.currentTag);
            taggedDMSDocuments.setDocuments(documentsToTransfer);
            Tag tagToRemoveFrom = taggedDMSDocuments.getTagToRemove();
            if (tagToRemoveFrom != null) {
                this.switchTagForDocuments(taggedDMSDocuments);
            } else {
                this.addTagToDocuments(taggedDMSDocuments);
            }
        }
    }

    private void onPreparePrint() {
        this.getDocumentForPopupActionOrSelection().ifPresent(document -> ((CompletableFuture)this.documentService.loadDocument((DmsDocument)document).thenAccept(this::onPrint)).exceptionally(this::onFailedDocumentContentLoad));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPrint(DmsDocument document) {
        block5: {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            try {
                this.actionService.enableGlobalActionsForNativeDialogs(false);
                if (!printJob.printDialog()) break block5;
                try {
                    File file = this.localStorageService.getTempFilePath(document.getStorageId()).toFile();
                    PDDocument pdfDocument = Loader.loadPDF((File)file);
                    PDFPageable pageable = new PDFPageable(pdfDocument);
                    printJob.setPageable((Pageable)pageable);
                    printJob.print();
                }
                catch (PrinterException | IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.actionService.enableGlobalActionsForNativeDialogs(true);
            }
        }
    }

    private Optional<DmsDocument> getDocumentForPopupActionOrSelection() {
        DmsDocument document = null;
        if (this.popupMenuActionModelRowIndex > -1) {
            document = (DmsDocument)this.documentTableModel.getRows().get(this.popupMenuActionModelRowIndex);
        } else if (this.selectedModelRowIndices != null && this.selectedModelRowIndices.length == 1) {
            document = (DmsDocument)this.documentTableModel.getRows().get(this.selectedModelRowIndices[0]);
        }
        return Optional.ofNullable(document);
    }

    private void onPageSelected(int page) {
        this.currentSelectedDocumentPage = page;
    }

    private void onDocumentDoubleClicked(int[] selectedModelRowIndices) {
        if (selectedModelRowIndices != null && selectedModelRowIndices.length == 1) {
            this.onShowDocumentEditor();
        }
    }

    private void onAttributeDoubleClicked(DocumentAttribute attribute) {
        this.onShowDocumentEditor();
    }

    private void onSelectAttribute(DocumentAttribute attribute) {
        this.currentDocumentAttribute = attribute;
    }

    private void onEditDocument() {
        if (this.selectedModelRowIndices != null && this.selectedModelRowIndices.length == 1) {
            this.onShowDocumentEditor();
        }
    }

    private void onShowDocumentEditor() {
        this.documentEditPanel.initUI(this.currentDocument, this.currentDocumentAttribute, this.existingDescriptions);
        JFrame parent = this.uiUtils.findMainFrame(this.documentTablePanel);
        OkCancelDialog dialog = new OkCancelDialog((Window)parent, this.i18n);
        dialog.setTitle(this.i18n.t("document.edit.title", this.currentDocument.getId().toString()));
        dialog.createUI();
        dialog.getContentPane().add((Component)this.documentEditPanel, "Center");
        dialog.setSize(600, 400);
        dialog.center();
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            String previousDescription = this.currentDocument.getDescription();
            this.documentEditPanel.applyToDocument(this.currentDocument);
            this.checkDescriptionChanged(previousDescription, this.currentDocument.getDescription());
            ((CompletableFuture)this.documentService.updateDocument(this.currentDocument).thenAccept(this::onDocumentUpdated)).exceptionally(this::onFailedDocumentUpdated);
        }
    }

    private void checkDescriptionChanged(String previousDescription, String description) {
        if (!Objects.equals(previousDescription, description) && !this.existingDescriptions.contains(description)) {
            this.existingDescriptions.add(description);
        }
    }

    @Override
    public void loadAnalyzedDocumentContent(Consumer<List<DocumentWord>> contentConsumer) {
        ((CompletableFuture)this.documentService.loadAnalyzedContentFor(this.currentDocument).thenAccept((Consumer)contentConsumer)).exceptionally(this::onFailedLoadAnalyzedDocumentContent);
    }

    private Void onFailedLoadAnalyzedDocumentContent(Throwable t) {
        this.errorController.findException(t, DocumentLoadAnaylzedContentException.class).ifPresentOrElse(documentLoadAnaylzedContentException -> this.errorController.handleError(ErrorCode.documentLoadAnalyzedContentFailed, (Throwable)documentLoadAnaylzedContentException, documentLoadAnaylzedContentException.getDocument().getId()), () -> this.errorController.handleError(ErrorCode.documentUpdateFailed, t, new Object[0]));
        return null;
    }

    private void onDocumentUpdated(Void unused) {
        this.currentDocument.setChangeDate(OffsetDateTime.now());
        this.currentDocument.setChangeUser(this.authService.getUser().getName());
        this.documentTableModel.fireTableRowsUpdated(this.currentRowIndex, this.currentRowIndex);
        this.loadDocumentTags(this.currentDocument);
    }

    private Void onFailedDocumentUpdated(Throwable t) {
        this.errorController.findException(t, DocumentUpdateFailedException.class).ifPresentOrElse(documentUpdateFailedException -> this.errorController.handleError(ErrorCode.documentUpdateFailed, (Throwable)documentUpdateFailedException, documentUpdateFailedException.getDocument().getId()), () -> this.errorController.handleError(ErrorCode.documentUpdateFailed, t, new Object[0]));
        return null;
    }

    public void loadDescriptions() {
        this.documentService.loadExistingDescriptions().thenAccept(existingDescriptions -> {
            this.existingDescriptions = new ArrayList<String>(existingDescriptions.stream().sorted().toList());
        });
    }

    private void loadSearchResultForTag(Tag tag) {
        if (tag != null && this.authService.isAuthenticated()) {
            ((CompletableFuture)this.searchService.findDocumentsWithText(tag.getName()).thenAccept(documents -> this.onDocumentListLoaded((List<DmsDocument>)documents, -1L, true))).exceptionally(this::onFailedSearch);
        } else {
            this.documentTableModel.getRows().clear();
            this.documentTableModel.fireTableDataChanged();
            this.setDocumentCountLabel(0);
        }
    }

    private Void onFailedSearch(Throwable t) {
        this.errorController.findException(t, DocumentSearchResultEmptyException.class).ifPresentOrElse(documentSearchResultEmptyException -> this.errorController.handleError(ErrorCode.documentSearchEmpty, (Throwable)documentSearchResultEmptyException, documentSearchResultEmptyException.getText()), () -> this.errorController.findException(t, DocumentSearchFailedException.class).ifPresentOrElse(documentSearchFailedException -> this.errorController.handleError(ErrorCode.documentSearchFailed, (Throwable)documentSearchFailedException, documentSearchFailedException.getText()), () -> this.errorController.handleError(ErrorCode.documentSearchFailed, t, new Object[0])));
        this.documentTableModel.getRows().clear();
        this.documentTableModel.fireTableDataChanged();
        this.documentTablePanel.selectRow(-1);
        return null;
    }

    private void onShowEditPdf() {
        if (this.currentDocument != null) {
            this.pdfEditPanel.initUI(this.localStorageService.getTempFilePath(this.currentDocument.getStorageId()).toFile());
            JFrame parent = this.uiUtils.findMainFrame(this.documentTablePanel);
            OkCancelDialog dialog = new OkCancelDialog((Window)parent, this.i18n);
            dialog.setTitle(this.i18n.t("document.edit.title", this.currentDocument.getId().toString()));
            dialog.createUI();
            dialog.getContentPane().add((Component)this.pdfEditPanel, "Center");
            try {
                dialog.setBounds(this.appPreferences.get("pdfEditor.bounds", RectangleWrapper.class).asRectangle());
            }
            catch (Exception e) {
                log.warn("Failed to load mainFrame properties; defaulting.", (Throwable)e);
                dialog.setSize(1024, 800);
                dialog.center();
            }
            dialog.setResizable(true);
            dialog.setVisible(true);
            this.pdfEditPanel.storeProperties(dialog.getBounds());
            if (!dialog.isCanceled()) {
                this.saveDocument(this.pdfEditPanel.getPdfDocument());
            }
        }
    }

    private void saveDocument(PDDocument pdfDocument) {
        try {
            String newStorageId = UUID.randomUUID().toString();
            pdfDocument.save(this.localStorageService.getTempFilePath(newStorageId).toFile());
            this.currentDocument.setStorageId(newStorageId);
            ((CompletableFuture)this.documentService.updateDocumentData(this.currentDocument, this.localStorageService.getTempFilePath(this.currentDocument.getStorageId()).toFile()).thenAccept(this::onDocumentContentLoaded)).exceptionally(this::onFailedDocumentContentUpdated);
        }
        catch (IOException e) {
            this.errorController.handleError(ErrorCode.documentUpdateFailed, e, new Object[0]);
        }
    }

    private Void onFailedDocumentContentUpdated(Throwable throwable) {
        this.errorController.findException(throwable, DocumentUpdateFailedException.class).ifPresentOrElse(documentUpdateFailedException -> this.errorController.handleError(ErrorCode.documentUpdateFailed, (Throwable)documentUpdateFailedException, throwable.getMessage()), () -> this.errorController.handleError(ErrorCode.documentUpdateFailed, throwable, new Object[0]));
        return null;
    }

    public void clear() {
        this.onSelectedTag(null, null);
    }

    @Generated
    public DocumentController(DocumentTablePanel documentTablePanel, TagTreePanel tagTreePanel, DocumentService documentService, I18nService i18n, DropDocumentController dropDocumentController, LocalStorageService localStorageService, DocumentPreviewPanel documentPreviewPanel, ErrorController errorController, ActionService actionService, UIUtils uiUtils, FileDialogs fileDialogs, ExportService exportService, SettingsService<AppSettings> settingsService, AuthService authService, DocumentEditPanel documentEditPanel, DocumentFilenameService documentFilenameService, PDFEditPanel pdfEditPanel, DocumentAttributesPanel documentAttributesPanel, SearchService searchService, AppPreferences appPreferences) {
        this.documentTablePanel = documentTablePanel;
        this.tagTreePanel = tagTreePanel;
        this.documentService = documentService;
        this.i18n = i18n;
        this.dropDocumentController = dropDocumentController;
        this.localStorageService = localStorageService;
        this.documentPreviewPanel = documentPreviewPanel;
        this.errorController = errorController;
        this.actionService = actionService;
        this.uiUtils = uiUtils;
        this.fileDialogs = fileDialogs;
        this.exportService = exportService;
        this.settingsService = settingsService;
        this.authService = authService;
        this.documentEditPanel = documentEditPanel;
        this.documentFilenameService = documentFilenameService;
        this.pdfEditPanel = pdfEditPanel;
        this.documentAttributesPanel = documentAttributesPanel;
        this.searchService = searchService;
        this.appPreferences = appPreferences;
    }

    @Generated
    public List<DocumentSelectionListener> getDocumentSelectionListeners() {
        return this.documentSelectionListeners;
    }
}

