/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.controller;

import jakarta.annotation.PostConstruct;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.dms.client.model.DmsUser;
import net.schembs.solutions.dms.client.service.AdminService;
import net.schembs.solutions.dms.client.ui.general.admin.AdminPanel;
import net.schembs.solutions.dms.client.ui.general.admin.UserEditorPanel;
import net.schembs.solutions.dms.client.ui.general.admin.UserTableModel;
import net.schembs.solutions.dms.client.ui.general.admin.UserTablePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class AdminController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminController.class);
    private final AdminService adminService;
    private final UserTablePanel userTablePanel;
    private final I18nService i18n;
    private final UserEditorPanel userEditorPanel;
    private final AdminPanel adminPanel;
    private UserTableModel userTableModel;
    private DmsUser currentUser;

    @PostConstruct
    void init() {
        this.userTableModel = new UserTableModel(this.i18n);
        this.userTablePanel.setModel(this.userTableModel);
        this.userTablePanel.getSelectionListeners().add(this::onSelectUser);
        this.userTablePanel.setOnAdd(this::onAddUser);
        this.userEditorPanel.setOnSave(this::onSave);
        this.userEditorPanel.setOnCancelNew(this::onCancelNew);
    }

    public void showAdmin(JFrame frame) {
        JDialog dialog = new JDialog(frame);
        dialog.setTitle(this.i18n.t("admin.title", new Object[0]));
        dialog.setResizable(false);
        dialog.setContentPane(this.adminPanel);
        this.adminPanel.initUI();
        dialog.pack();
        dialog.setLocationRelativeTo(frame);
        this.loadUsers();
        dialog.setVisible(true);
    }

    private void onAddUser() {
        this.userTableModel.getRows().add(DmsUser.builder().username(this.i18n.t("admin.userTable.newUser", new Object[0])).newUser(true).build());
        this.userTableModel.fireTableDataChanged();
        this.userTablePanel.selectModelRow(this.userTableModel.getRowCount() - 1);
    }

    private void onCancelNew(DmsUser dmsUser) {
        this.userTableModel.getRows().remove(dmsUser);
        this.userTableModel.fireTableDataChanged();
        this.userTablePanel.selectRow(0);
    }

    private void onSelectUser(int[] rows) {
        if (rows != null && rows.length == 1) {
            if (this.userEditorPanel.isNewUser()) {
                this.userTableModel.getRows().stream().filter(DmsUser::isNewUser).findFirst().ifPresent(dmsUser -> {
                    this.userTableModel.getRows().remove(dmsUser);
                    this.userTableModel.fireTableDataChanged();
                    this.userTablePanel.selectModelRow(rows[0]);
                });
            } else if (this.userEditorPanel.isChanged()) {
                if (this.userEditorPanel.isUserValid()) {
                    if (JOptionPane.showConfirmDialog(this.userEditorPanel, this.i18n.t("confirm.unsaved.changes", new Object[0]), this.i18n.t("confirm.title", new Object[0]), 0) == 0) {
                        this.userEditorPanel.onSave();
                    }
                } else {
                    JOptionPane.showMessageDialog(this.userEditorPanel, this.i18n.t("error.admin.invalid.cannot.be.saved", new Object[0]));
                }
            }
            DmsUser user = (DmsUser)this.userTableModel.getRows().get(rows[0]);
            this.loadUserData(user);
        }
    }

    private void loadUserData(DmsUser user) {
        if (!user.isNewUser()) {
            this.adminService.loadUser(user.getUsername()).thenAccept(this::onUserLoaded);
        } else {
            this.onUserLoaded(user);
        }
    }

    private void onUserLoaded(DmsUser dmsUser) {
        this.currentUser = dmsUser;
        this.userEditorPanel.setUser(dmsUser);
    }

    private void onSave(DmsUser dmsUser) {
        if (dmsUser.isNewUser()) {
            this.adminService.createUser(dmsUser);
        } else {
            this.adminService.updateUser(this.currentUser.getUsername(), dmsUser);
        }
        this.loadUsers();
    }

    private void loadUsers() {
        this.userTableModel.getRows().clear();
        this.adminService.loadUsers().thenAccept(this::onUsersLoaded);
    }

    private void onUsersLoaded(List<DmsUser> dmsUsers) {
        this.userEditorPanel.setUserNameList(dmsUsers.stream().map(DmsUser::getUsername).map(String::toLowerCase).toList());
        this.userTableModel.getRows().addAll(dmsUsers);
        this.userTableModel.fireTableDataChanged();
        this.userTablePanel.selectRow(0);
    }

    @Generated
    public AdminController(AdminService adminService, UserTablePanel userTablePanel, I18nService i18n, UserEditorPanel userEditorPanel, AdminPanel adminPanel) {
        this.adminService = adminService;
        this.userTablePanel = userTablePanel;
        this.i18n = i18n;
        this.userEditorPanel = userEditorPanel;
        this.adminPanel = adminPanel;
    }
}

