/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.config;

import java.util.function.Supplier;
import net.schembs.solutions.dms.client.service.BackendProvider;
import net.schembs.solutions.dms.security.config.AuthConfig;
import net.schembs.solutions.dms.security.service.AuthService;
import net.schembs.solutions.dms.security.service.BackendUrlProvider;
import net.schembs.solutions.dms.security.service.RootUriSupplierUriTemplateHandler;
import net.schembs.solutions.dms.security.service.SecurityConfigurationService;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

@Configuration
@Import(value={AuthConfig.class})
public class SecurityConfig {
    @Bean
    public BackendUrlProvider backendUrlProvider(BackendProvider backendProvider) {
        return backendProvider::getUrl;
    }

    @Bean
    public RestTemplate authServerUserRestTemplate(AuthService authService, SecurityConfigurationService securityConfigurationService) {
        return this.createAuthorizedTemplate(authService, () -> ((SecurityConfigurationService)securityConfigurationService).getAuthServerUserEndpoint());
    }

    @Bean
    public RestTemplate authServerAdminRestTemplate(AuthService authService, SecurityConfigurationService securityConfigurationService) {
        return this.createAuthorizedTemplate(authService, () -> ((SecurityConfigurationService)securityConfigurationService).getAuthServerAdminEndpoint());
    }

    private RestTemplate createAuthorizedTemplate(AuthService authService, Supplier<String> endpointSupplier) {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        return restTemplateBuilder.uriTemplateHandler((UriTemplateHandler)new RootUriSupplierUriTemplateHandler(endpointSupplier)).additionalInterceptors(new ClientHttpRequestInterceptor[]{(request, body, execution) -> {
            if (authService != null && authService.isAuthenticated()) {
                request.getHeaders().add("Authorization", "Bearer " + authService.getUser().getAccessToken());
            }
            return execution.execute(request, body);
        }}).build();
    }
}

