/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.config;

import net.schembs.solutions.dms.client.service.BackendProvider;
import net.schembs.solutions.dms.security.service.AuthService;
import net.schembs.solutions.dms.security.service.RootUriSupplierUriTemplateHandler;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

@Configuration
public class DocumentStoreConfig {
    @Bean
    public RestTemplate documentStoreRestTemplate(AuthService authService, BackendProvider backendProvider) {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        return restTemplateBuilder.uriTemplateHandler((UriTemplateHandler)new RootUriSupplierUriTemplateHandler(backendProvider::getUrl)).additionalInterceptors(new ClientHttpRequestInterceptor[]{(request, body, execution) -> {
            if (authService != null && authService.isAuthenticated()) {
                request.getHeaders().add("Authorization", "Bearer " + authService.getUser().getAccessToken());
            }
            return execution.execute(request, body);
        }}).build();
    }
}

