/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.config;

import java.util.Arrays;
import java.util.List;
import net.schembs.solutions.desktopclient.model.LayoutsConfig;
import net.schembs.solutions.desktopclient.ui.layout.AppLayout;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppLayoutConfig
implements LayoutsConfig {
    @Override
    public List<String> getLayoutNames() {
        return Arrays.stream(Layouts.values()).map(Enum::name).toList();
    }

    @Override
    public AppLayout getLayoutDefaultFor(String layoutName) {
        Layouts layout = Layouts.valueOf(layoutName);
        return switch (layout.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> AppLayoutConfig.createDefaultDocumentsLayout();
            case 1 -> AppLayoutConfig.createDefaultAdminLayout();
        };
    }

    @Override
    public boolean isClearLayouts() {
        return false;
    }

    public static AppLayout createDefaultDocumentsLayout() {
        return AppLayout.builder().data(AppLayout.AppLayoutData.builder().name(Layouts.document.name()).type(AppLayout.WindowType.verticalPair).init(AppLayout.AppLayoutInit.builder().fixedSecond(200).build()).build()).first(AppLayout.builder().data(AppLayout.AppLayoutData.builder().name("documentWorkPanel").init(AppLayout.AppLayoutInit.builder().fixedFirst(200).build()).type(AppLayout.WindowType.horizontalPair).build()).first(AppLayout.builder().data(AppLayout.AppLayoutData.builder().name("tagTreePanel").build()).hasAppToolbar(true).build()).second(AppLayout.builder().hasAppToolbar(true).data(AppLayout.AppLayoutData.builder().type(AppLayout.WindowType.horizontalPair).name("centerRight").init(AppLayout.AppLayoutInit.builder().relative(70).build()).build()).first(AppLayout.builder().data(AppLayout.AppLayoutData.builder().name("documentTablePanel").build()).build()).second(AppLayout.builder().data(AppLayout.AppLayoutData.builder().type(AppLayout.WindowType.horizontalPair).type(AppLayout.WindowType.verticalPair).name("rightPanel").init(AppLayout.AppLayoutInit.builder().relative(80).build()).build()).first(AppLayout.builder().data(AppLayout.AppLayoutData.builder().name("documentPreviewPanel").build()).build()).second(AppLayout.builder().data(AppLayout.AppLayoutData.builder().name("documentAttributesPanel").build()).build()).build()).build()).build()).second(AppLayout.builder().data(AppLayout.AppLayoutData.builder().name("documentDropPanel").type(AppLayout.WindowType.horizontalPair).init(AppLayout.AppLayoutInit.builder().fixedSecond(200).build()).build()).first(AppLayout.builder().data(AppLayout.AppLayoutData.builder().name("dropTablePanel").build()).build()).second(AppLayout.builder().data(AppLayout.AppLayoutData.builder().name("dropPreview").build()).build()).build()).build();
    }

    public static AppLayout createDefaultAdminLayout() {
        return AppLayout.builder().data(AppLayout.AppLayoutData.builder().name(Layouts.admin.name()).type(AppLayout.WindowType.horizontalPair).init(AppLayout.AppLayoutInit.builder().fixedSecond(500).build()).build()).first(AppLayout.builder().data(AppLayout.AppLayoutData.builder().name("userTablePanel").build()).build()).second(AppLayout.builder().data(AppLayout.AppLayoutData.builder().name("userEditorPanel").build()).build()).build();
    }

    public static enum Layouts {
        document,
        admin;

    }
}

