/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.client.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.schembs.solutions.dms.client.client.api.model.TagTreeNode;

@JsonPropertyOrder(value={"node", "parent", "changeType", "parentMovePosition", "parentPositions"})
public class TreeChange {
    public static final String JSON_PROPERTY_NODE = "node";
    @Nullable
    private TagTreeNode node;
    public static final String JSON_PROPERTY_PARENT = "parent";
    @Nullable
    private TagTreeNode parent;
    public static final String JSON_PROPERTY_CHANGE_TYPE = "changeType";
    @Nullable
    private ChangeTypeEnum changeType;
    public static final String JSON_PROPERTY_PARENT_MOVE_POSITION = "parentMovePosition";
    @Nullable
    private Integer parentMovePosition;
    public static final String JSON_PROPERTY_PARENT_POSITIONS = "parentPositions";
    @Nullable
    private List<String> parentPositions = new ArrayList<String>();

    public TreeChange node(@Nullable TagTreeNode node) {
        this.node = node;
        return this;
    }

    @Nullable
    @JsonProperty(value="node")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TagTreeNode getNode() {
        return this.node;
    }

    @JsonProperty(value="node")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNode(@Nullable TagTreeNode node) {
        this.node = node;
    }

    public TreeChange parent(@Nullable TagTreeNode parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TagTreeNode getParent() {
        return this.parent;
    }

    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParent(@Nullable TagTreeNode parent) {
        this.parent = parent;
    }

    public TreeChange changeType(@Nullable ChangeTypeEnum changeType) {
        this.changeType = changeType;
        return this;
    }

    @Nullable
    @JsonProperty(value="changeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeTypeEnum getChangeType() {
        return this.changeType;
    }

    @JsonProperty(value="changeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeType(@Nullable ChangeTypeEnum changeType) {
        this.changeType = changeType;
    }

    public TreeChange parentMovePosition(@Nullable Integer parentMovePosition) {
        this.parentMovePosition = parentMovePosition;
        return this;
    }

    @Nullable
    @JsonProperty(value="parentMovePosition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getParentMovePosition() {
        return this.parentMovePosition;
    }

    @JsonProperty(value="parentMovePosition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParentMovePosition(@Nullable Integer parentMovePosition) {
        this.parentMovePosition = parentMovePosition;
    }

    public TreeChange parentPositions(@Nullable List<String> parentPositions) {
        this.parentPositions = parentPositions;
        return this;
    }

    public TreeChange addParentPositionsItem(String parentPositionsItem) {
        if (this.parentPositions == null) {
            this.parentPositions = new ArrayList<String>();
        }
        this.parentPositions.add(parentPositionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="parentPositions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getParentPositions() {
        return this.parentPositions;
    }

    @JsonProperty(value="parentPositions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParentPositions(@Nullable List<String> parentPositions) {
        this.parentPositions = parentPositions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeChange treeChange = (TreeChange)o;
        return Objects.equals(this.node, treeChange.node) && Objects.equals(this.parent, treeChange.parent) && Objects.equals((Object)this.changeType, (Object)treeChange.changeType) && Objects.equals(this.parentMovePosition, treeChange.parentMovePosition) && Objects.equals(this.parentPositions, treeChange.parentPositions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.node, this.parent, this.changeType, this.parentMovePosition, this.parentPositions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TreeChange {\n");
        sb.append("    node: ").append(this.toIndentedString(this.node)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    changeType: ").append(this.toIndentedString((Object)this.changeType)).append("\n");
        sb.append("    parentMovePosition: ").append(this.toIndentedString(this.parentMovePosition)).append("\n");
        sb.append("    parentPositions: ").append(this.toIndentedString(this.parentPositions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ChangeTypeEnum {
        NEW_NODE(String.valueOf("newNode")),
        RENAME(String.valueOf("rename")),
        MOVED(String.valueOf("moved")),
        DELETE_NODE(String.valueOf("deleteNode")),
        REORDER(String.valueOf("reorder"));

        private String value;

        private ChangeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChangeTypeEnum fromValue(String value) {
            for (ChangeTypeEnum b : ChangeTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

