/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.osspecific.win;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.schembs.solutions.desktopclient.ui.osspecific.UISystem;

public class WindowsSystem {
    private static final Pattern THEME_PATTERN = Pattern.compile("AppsUseLightTheme\\s+REG_DWORD\\s+0x(\\d+)");

    private static boolean isDarkMode() {
        try {
            int rc;
            String line;
            boolean isDarkMode = false;
            Process process = Runtime.getRuntime().exec(new String[]{"reg", "query", "\"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize\"", "/v", "AppsUseLightTheme"});
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader rdr = new BufferedReader(isr);
            while ((line = rdr.readLine()) != null) {
                Matcher matcher = THEME_PATTERN.matcher(line);
                if (!matcher.find()) continue;
                isDarkMode = Integer.parseInt(matcher.group(1)) == 0;
                break;
            }
            return (rc = process.waitFor()) == 0 && isDarkMode;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Boolean setupPLaF(UISystem.Theme theme) {
        boolean isDarkMode;
        boolean bl = theme == UISystem.Theme.system ? WindowsSystem.isDarkMode() : (isDarkMode = theme == UISystem.Theme.dark);
        if (isDarkMode) {
            FlatDarkLaf.setup();
        } else {
            FlatLightLaf.setup();
        }
        return isDarkMode;
    }
}

