/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.osspecific.mac;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import lombok.Generated;
import net.schembs.solutions.desktopclient.ui.general.AppWindowListener;
import net.schembs.solutions.desktopclient.ui.osspecific.mac.Mac;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mac
public class MacWindowFrameManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MacWindowFrameManager.class);
    private Rectangle currentBounds;
    private boolean maximized;
    private JFrame frame;
    private final List<AppWindowListener> listeners = new ArrayList<AppWindowListener>();

    public void installListeners(JFrame frame) {
        this.frame = frame;
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MacWindowFrameManager.this.onComponentChanged(e.getComponent().getBounds());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                MacWindowFrameManager.this.onComponentChanged(e.getComponent().getBounds());
            }
        });
    }

    private void onComponentChanged(Rectangle bounds) {
        if (bounds.y == 0) {
            if (!this.isMaximized()) {
                this.onMaximized(bounds);
            }
        } else if (this.isMaximized()) {
            this.onNormalize(bounds);
        } else if (!bounds.equals(this.currentBounds)) {
            Rectangle previousBounds = this.currentBounds;
            this.onBoundsChanged(bounds);
            if (previousBounds == null || !bounds.getLocation().equals(previousBounds.getLocation())) {
                this.onLocationChanged(bounds.getLocation());
            }
            if (previousBounds == null || !bounds.getSize().equals(previousBounds.getSize())) {
                this.onSizeChanged(bounds.getSize());
            }
        }
    }

    private void onSizeChanged(Dimension dimension) {
        log.debug("Size changed: {}", (Object)this);
        this.listeners.forEach(l -> l.onSizeChanged(dimension));
    }

    private void onLocationChanged(Point location) {
        log.debug("Location changed: {}", (Object)this);
        this.listeners.forEach(l -> l.onLocationChanged(location));
    }

    private void onBoundsChanged(Rectangle bounds) {
        this.currentBounds = bounds;
        log.debug("Bounds changed: {}", (Object)this);
        this.listeners.forEach(l -> l.onBoundsChanged(bounds));
    }

    private void onMaximized(Rectangle bounds) {
        this.maximized = true;
        log.debug("Maximized: {}", (Object)this);
        SwingUtilities.invokeLater(() -> this.listeners.forEach(l -> l.onMaximized(bounds)));
    }

    private void onNormalize(Rectangle bounds) {
        this.maximized = false;
        log.debug("Normalized: {}", (Object)this);
        SwingUtilities.invokeLater(() -> this.listeners.forEach(l -> l.onNormalized(bounds)));
    }

    @Generated
    public MacWindowFrameManager() {
    }

    @Generated
    public String toString() {
        return "MacWindowFrameManager(currentBounds=" + String.valueOf(this.getCurrentBounds()) + ", maximized=" + this.isMaximized() + ", frame=" + String.valueOf(this.getFrame()) + ", listeners=" + String.valueOf(this.getListeners()) + ")";
    }

    @Generated
    public Rectangle getCurrentBounds() {
        return this.currentBounds;
    }

    @Generated
    public boolean isMaximized() {
        return this.maximized;
    }

    @Generated
    public JFrame getFrame() {
        return this.frame;
    }

    @Generated
    public List<AppWindowListener> getListeners() {
        return this.listeners;
    }
}

