/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.osspecific.mac;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jiconfont.IconCode;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.UIUtils;
import net.schembs.solutions.desktopclient.ui.general.AppToolBar;
import net.schembs.solutions.desktopclient.ui.general.RoundedPanel;
import net.schembs.solutions.desktopclient.ui.general.ToolbarIconButton;

public abstract class MacToolBar
extends JToolBar
implements AppToolBar {
    private final UIUtils uiUtils;
    private final ActionService actionService;
    private final I18nService i18nService;
    private final ColorConfig colorConfig;

    @PostConstruct
    public void createUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(this.colorConfig.getBarBackground());
        JPanel leftPanel = this.createPanel(0);
        JPanel midPanel = this.createPanel(1);
        JPanel rightPanel = this.createPanel(4);
        this.configureLeftPanel(leftPanel);
        this.configureMidPanel(midPanel);
        this.configureRightPanel(rightPanel);
        this.add((Component)leftPanel, "West");
        this.add((Component)midPanel, "Center");
        this.add((Component)rightPanel, "East");
    }

    protected JPanel createPanel(int flowLayoutOrientation) {
        int h = 37;
        JPanel panel = new JPanel(new FlowLayout(flowLayoutOrientation, 5, 0));
        panel.setBackground(this.colorConfig.getBarBackground());
        panel.add(Box.createVerticalStrut(h));
        return panel;
    }

    protected JPanel createSection() {
        RoundedPanel section = new RoundedPanel();
        section.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 6));
        section.add(Box.createVerticalStrut(31));
        section.setBackground(this.colorConfig.getToolBarPartBackground());
        return section;
    }

    protected ToolbarIconButton createToolButton(IconCode iconCode, Enum<?> action) {
        return new ToolbarIconButton(this.uiUtils.getFontIcon(iconCode, 24, this.colorConfig.getToolBarIconColor()), this.uiUtils.getFontIcon(iconCode, 24, this.colorConfig.getLabelForeground()), ToolbarIconButton.ToolbarIconButtonColors.builder().hoverBackground(this.colorConfig.getToolBarButtonHoverBackground()).badgeBackground(this.colorConfig.getPrimaryColor()).badgeForeground(this.colorConfig.getLabelForeground()).build(), this.i18nService.t(action.toString(), new Object[0]), this.actionService.getAction(action));
    }

    protected abstract void configureLeftPanel(JPanel var1);

    protected abstract void configureMidPanel(JPanel var1);

    protected abstract void configureRightPanel(JPanel var1);

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Generated
    public MacToolBar(UIUtils uiUtils, ActionService actionService, I18nService i18nService, ColorConfig colorConfig) {
        this.uiUtils = uiUtils;
        this.actionService = actionService;
        this.i18nService = i18nService;
        this.colorConfig = colorConfig;
    }
}

