/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.osspecific.mac;

import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.schembs.solutions.desktopclient.ui.osspecific.UISystem;

public class MacOSSystem {
    public static void registerApplicationName(String applicationName) {
        System.setProperty("apple.awt.application.name", applicationName);
    }

    private static boolean isDarkMode() {
        try {
            String line;
            boolean isDarkMode = false;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(new String[]{"defaults", "read", "-g", "AppleInterfaceStyle"});
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader rdr = new BufferedReader(isr);
            while ((line = rdr.readLine()) != null) {
                if (!line.equals("Dark")) continue;
                isDarkMode = true;
            }
            int rc = process.waitFor();
            return 0 == rc && isDarkMode;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    public static boolean setupPLaF(UISystem.Theme theme) {
        boolean isDarkMode;
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.application.appearance", "system");
        boolean bl = theme == UISystem.Theme.system ? MacOSSystem.isDarkMode() : (isDarkMode = theme == UISystem.Theme.dark);
        if (isDarkMode) {
            FlatMacDarkLaf.setup();
        } else {
            FlatMacLightLaf.setup();
        }
        return isDarkMode;
    }
}

