/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.osspecific.mac;

import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import lombok.Generated;
import net.schembs.solutions.desktopclient.ui.general.AppDelegate;
import net.schembs.solutions.desktopclient.ui.general.AppWindowAdapter;
import net.schembs.solutions.desktopclient.ui.general.MainFrame;
import net.schembs.solutions.desktopclient.ui.layout.AppLayoutService;
import net.schembs.solutions.desktopclient.ui.osspecific.MainFrameConfigurator;
import net.schembs.solutions.desktopclient.ui.osspecific.mac.MacWindowFrameManager;

public class MacMainFrameConfigurator
implements MainFrameConfigurator {
    private final MacWindowFrameManager windowFrameManager;
    private final AppLayoutService appLayoutService;

    @Override
    public void createUI(MainFrame mainFrame, final AppDelegate appDelegate) {
        JFrame frame = mainFrame.getFrame();
        this.windowFrameManager.installListeners(frame);
        this.windowFrameManager.getListeners().add(new AppWindowAdapter(){

            @Override
            public void onMaximized(Rectangle bounds) {
                MacMainFrameConfigurator.this.appLayoutService.setSaveLayouts(false);
            }

            @Override
            public void onNormalized(Rectangle bounds) {
                MacMainFrameConfigurator.this.appLayoutService.setSaveLayouts(true);
            }
        });
        if (SystemInfo.isMacFullWindowContentSupported) {
            frame.getRootPane().putClientProperty("apple.awt.transparentTitleBar", true);
            frame.getRootPane().putClientProperty("apple.awt.fullWindowContent", true);
        }
        frame.setDefaultCloseOperation(0);
        Desktop.getDesktop().setQuitHandler((e, response) -> {
            response.cancelQuit();
            appDelegate.onPrepareClose();
        });
        Desktop.getDesktop().setPreferencesHandler(e -> appDelegate.showPreferences());
        Desktop.getDesktop().setAboutHandler(e -> appDelegate.showAboutWindow());
        frame.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                appDelegate.onPrepareClose();
            }
        });
    }

    @Override
    public Rectangle getCurrentBounds(MainFrame mainFrame) {
        return this.windowFrameManager.getCurrentBounds();
    }

    @Generated
    public MacMainFrameConfigurator(MacWindowFrameManager windowFrameManager, AppLayoutService appLayoutService) {
        this.windowFrameManager = windowFrameManager;
        this.appLayoutService = appLayoutService;
    }
}

