/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.osspecific;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.config.OperatingSystem;
import net.schembs.solutions.desktopclient.model.BasicAppSettings;
import net.schembs.solutions.desktopclient.ui.osspecific.mac.MacOSSystem;
import net.schembs.solutions.desktopclient.ui.osspecific.win.WindowsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UISystem {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UISystem.class);
    private static Boolean darkMode;

    public static void setupPLaF(Class<?> applicationClass) {
        Theme theme = UISystem.getPlafPrefs(applicationClass);
        if (OperatingSystem.isMac()) {
            darkMode = MacOSSystem.setupPLaF(theme);
        } else if (OperatingSystem.isWin()) {
            darkMode = WindowsSystem.setupPLaF(theme);
        } else {
            throw new UnsupportedOperationException("Unsupported OS");
        }
    }

    private static Theme getPlafPrefs(Class<?> applicationClass) {
        AppPreferences prefs = new AppPreferences(applicationClass, UISystem.createObjectMapper());
        Theme theme = Theme.system;
        try {
            BasicAppSettings appSettings = prefs.get("settings", BasicAppSettings.class);
            theme = Theme.valueOf(appSettings.getGeneral().getTheme());
        }
        catch (Exception e) {
            log.warn("Failed to load theme from settings. Using system.");
        }
        return theme;
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public static boolean isDarkMode() {
        return Boolean.TRUE.equals(darkMode);
    }

    public static enum Theme {
        light,
        dark,
        system;

    }
}

