/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.layout;

import jakarta.annotation.PostConstruct;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.model.LayoutsConfig;
import net.schembs.solutions.desktopclient.ui.layout.AppLayout;
import net.schembs.solutions.desktopclient.ui.layout.AppLayoutBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppLayoutService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppLayoutService.class);
    private static final String PREF_KEY = "layout.";
    private static final String PREF_KEY_CURRENT = "layout.current";
    private static final String PREF_KEY_LAYOUTS = "layout.layouts";
    private final AppLayoutBuilder appLayoutBuilder;
    private final AppPreferences appPreferences;
    private final LayoutsConfig layoutsConfig;
    private JPanel currentParent;
    private AppLayout currentLayout;
    private Map<String, AppLayout> layouts;
    private boolean saveLayouts = true;

    @PostConstruct
    public void init() {
        this.appPreferences.getShutdownHooks().add(this::onShutdown);
        this.layouts = new HashMap<String, AppLayout>();
        this.loadProperties();
        this.checkRequiredLayouts();
        this.linkSubLayouts();
    }

    private void loadProperties() {
        try {
            AppLayout[] layouts = this.appPreferences.get(PREF_KEY_LAYOUTS, AppLayout[].class);
            Arrays.stream(layouts).forEach(layout -> this.layouts.put(layout.getData().getName(), (AppLayout)layout));
        }
        catch (Exception e) {
            log.warn("Error loading app layouts. We will default.");
        }
    }

    private void checkRequiredLayouts() {
        boolean clearLayouts = this.layoutsConfig.isClearLayouts();
        if (clearLayouts) {
            this.layouts.clear();
        }
        for (String layoutName : this.layoutsConfig.getLayoutNames()) {
            if (!clearLayouts && this.layouts.containsKey(layoutName)) continue;
            this.layouts.put(layoutName, this.layoutsConfig.getLayoutDefaultFor(layoutName));
        }
    }

    private void linkSubLayouts() {
        HashMap<String, AppLayout.AppLayoutData> appLayoutDataMap = new HashMap<String, AppLayout.AppLayoutData>();
        for (AppLayout layout : this.layouts.values()) {
            this.linkSubLayouts(layout, appLayoutDataMap);
        }
    }

    private void linkSubLayouts(AppLayout layout, Map<String, AppLayout.AppLayoutData> appLayoutDataMap) {
        if (layout.getData().getType() == AppLayout.WindowType.horizontalPair || layout.getData().getType() == AppLayout.WindowType.verticalPair) {
            AppLayout.AppLayoutData data = appLayoutDataMap.get(layout.getData().getName());
            if (data == null) {
                appLayoutDataMap.put(layout.getData().getName(), layout.getData());
            } else {
                layout.setData(data);
            }
        }
    }

    public void selectLayout(String appView, JPanel mainPanel, Dimension size) {
        this.currentLayout = this.layouts.get(appView);
        this.createLayout(mainPanel, size);
    }

    public void createLayout(JPanel parent, Dimension dimension) {
        JPanel layout;
        this.currentParent = parent;
        parent.removeAll();
        try {
            layout = this.appLayoutBuilder.createLayout(this.currentLayout, dimension);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load create layout.", e);
        }
        parent.add((Component)layout, "Center");
        parent.revalidate();
        parent.repaint();
    }

    private void onShutdown(AppPreferences appPreferences) {
        this.storeProperties();
    }

    private void storeProperties() {
        this.appLayoutBuilder.capture((JPanel)this.currentParent.getComponent(0), this.currentLayout);
        this.appPreferences.put(PREF_KEY_CURRENT, this.currentLayout.getData().getName());
        if (this.saveLayouts) {
            this.appPreferences.put(PREF_KEY_LAYOUTS, this.layouts.values().toArray());
        }
    }

    @Generated
    public AppLayoutService(AppLayoutBuilder appLayoutBuilder, AppPreferences appPreferences, LayoutsConfig layoutsConfig) {
        this.appLayoutBuilder = appLayoutBuilder;
        this.appPreferences = appPreferences;
        this.layoutsConfig = layoutsConfig;
    }

    @Generated
    public void setSaveLayouts(boolean saveLayouts) {
        this.saveLayouts = saveLayouts;
    }
}

