/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.ui.layout.AppLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AppLayoutBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppLayoutBuilder.class);
    private final ApplicationContext ctx;
    private final ColorConfig colorConfig;
    private AppToolBarProvider appToolBarProvider;

    public JPanel createLayout(AppLayout layout, Dimension dimension) {
        if (AppLayout.WindowType.horizontalPair.equals((Object)layout.getData().getType())) {
            return this.splitWindow(layout, dimension, 1);
        }
        if (AppLayout.WindowType.verticalPair.equals((Object)layout.getData().getType())) {
            return this.splitWindow(layout, dimension, 0);
        }
        return this.singleWindow(layout);
    }

    private JPanel singleWindow(AppLayout layout) {
        JPanel panelHolder = new JPanel(new BorderLayout());
        this.applyToolbarIfNecessary(layout, panelHolder);
        panelHolder.add((Component)this.ctx.getBean(layout.getData().getName(), JPanel.class), "Center");
        return panelHolder;
    }

    private JPanel splitWindow(AppLayout layout, Dimension dimension, int orientation) {
        JPanel splitHolder = new JPanel(new BorderLayout());
        this.applyToolbarIfNecessary(layout, splitHolder);
        JSplitPane pane = new JSplitPane();
        pane.setBackground(this.colorConfig.getSeparatorColor());
        pane.setOrientation(orientation);
        splitHolder.add((Component)pane, "Center");
        int divider = AppLayoutBuilder.calcDivider(layout, dimension, orientation);
        pane.setDividerLocation(divider);
        Integer resizeWeight = layout.getData().getResizeWeight();
        if (resizeWeight == null) {
            if (layout.getData().getInit() == null || !AppLayoutBuilder.isFixed(layout.getData().getInit())) {
                resizeWeight = 100 - (int)(100.0 * ((double)divider / (double)(orientation == 0 ? dimension.height : dimension.width)));
            } else {
                resizeWeight = layout.getData().getInit().getFixedFirst() != null ? 0 : 100;
                layout.getData().setResizeWeight(resizeWeight);
            }
        }
        pane.setResizeWeight((double)resizeWeight.intValue() / 100.0);
        pane.setLeftComponent(this.createLayout(layout.getFirst(), this.adjustFirstDimension(dimension, divider, orientation)));
        pane.setRightComponent(this.createLayout(layout.getSecond(), this.adjustSecondimension(dimension, divider, orientation)));
        return splitHolder;
    }

    private static boolean isFixed(AppLayout.AppLayoutInit init) {
        return init.getFixedFirst() != null || init.getFixedSecond() != null;
    }

    private void applyToolbarIfNecessary(AppLayout layout, JPanel panel) {
        JComponent toolbar;
        if (this.appToolBarProvider != null && Boolean.TRUE.equals(layout.getHasAppToolbar()) && (toolbar = this.appToolBarProvider.getLayoutToolBar(layout.getData().getName())) != null) {
            panel.add((Component)toolbar, "North");
        }
    }

    private Dimension adjustFirstDimension(Dimension dimension, int divider, int orientation) {
        return orientation == 1 ? new Dimension(divider, dimension.height) : new Dimension(dimension.width, divider);
    }

    private Dimension adjustSecondimension(Dimension dimension, int divider, int orientation) {
        return orientation == 1 ? new Dimension(dimension.width - divider, dimension.height) : new Dimension(dimension.width, dimension.height - divider);
    }

    private static int calcDivider(AppLayout layout, Dimension dimension, int orientation) {
        if (layout.getData().getDividerLocation() != null) {
            return layout.getData().getDividerLocation();
        }
        if (layout.getData().getInit() != null) {
            return AppLayoutBuilder.getInitialDividerLocation(dimension, orientation, layout.getData().getInit());
        }
        return 0;
    }

    private static int getInitialDividerLocation(Dimension dimension, int orientation, AppLayout.AppLayoutInit init) {
        if (init.getRelative() != null) {
            double pc = (double)init.getRelative().intValue() / 100.0;
            int length = orientation == 0 ? dimension.height : dimension.width;
            return (int)(pc * (double)length);
        }
        if (init.getFixedFirst() != null) {
            return init.getFixedFirst();
        }
        if (init.getFixedSecond() != null) {
            int length = orientation == 0 ? dimension.height : dimension.width;
            return length - init.getFixedSecond();
        }
        return 0;
    }

    private JSplitPane findSplitPane(JPanel panel) {
        JSplitPane splitPane;
        Component centerComponent = ((BorderLayout)panel.getLayout()).getLayoutComponent("Center");
        return centerComponent instanceof JSplitPane ? (splitPane = (JSplitPane)centerComponent) : null;
    }

    public void capture(JPanel parent, AppLayout layout) {
        if (AppLayout.WindowType.horizontalPair.equals((Object)layout.getData().getType()) || AppLayout.WindowType.verticalPair.equals((Object)layout.getData().getType())) {
            JSplitPane pane = this.findSplitPane(parent);
            layout.getData().setDividerLocation(pane.getDividerLocation());
            this.capture((JPanel)pane.getLeftComponent(), layout.getFirst());
            this.capture((JPanel)pane.getRightComponent(), layout.getSecond());
        }
    }

    @Generated
    public AppLayoutBuilder(ApplicationContext ctx, ColorConfig colorConfig) {
        this.ctx = ctx;
        this.colorConfig = colorConfig;
    }

    @Generated
    public void setAppToolBarProvider(AppToolBarProvider appToolBarProvider) {
        this.appToolBarProvider = appToolBarProvider;
    }

    public static interface AppToolBarProvider {
        public JComponent getLayoutToolBar(String var1);
    }
}

