/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.general.xtable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.model.BasicAppSettings;
import net.schembs.solutions.desktopclient.model.TableRowIdProvider;
import net.schembs.solutions.desktopclient.model.TableSelection;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.service.TableActionService;
import net.schembs.solutions.desktopclient.ui.general.xtable.AbstractXTableModel;
import net.schembs.solutions.desktopclient.ui.general.xtable.TableActions;
import net.schembs.solutions.desktopclient.ui.general.xtable.TableColumnModel;
import net.schembs.solutions.desktopclient.ui.general.xtable.TablePopupProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XTable<T extends TableRowIdProvider>
extends JTable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XTable.class);
    private static final String TABLE = "table";
    private final I18nService i18n;
    private final AppPreferences appPreferences;
    private final ColorConfig colorConfig;
    private final SettingsService<? extends BasicAppSettings> settingsService;
    private final List<Consumer<int[]>> listSelectionListeners = new ArrayList<Consumer<int[]>>();
    private final List<Consumer<int[]>> clickListeners = new ArrayList<Consumer<int[]>>();
    private final List<BiConsumer<Object, Object>> markSelectionListeners = new ArrayList<BiConsumer<Object, Object>>();
    private final List<Object> markers = new ArrayList<Object>();
    private final List<Object> cachedSelection = new ArrayList<Object>();
    private final TableActionService tableActionService;
    private TablePopupProvider tablePopupProvider;

    public XTable(I18nService i18n, AppPreferences appPreferences, ColorConfig colorConfig, SettingsService<? extends BasicAppSettings> settingsService) {
        this(i18n, appPreferences, colorConfig, settingsService, true);
    }

    public XTable(I18nService i18n, AppPreferences appPreferences, ColorConfig colorConfig, SettingsService<? extends BasicAppSettings> settingsService, boolean withRowSorter) {
        this.i18n = i18n;
        this.appPreferences = appPreferences;
        this.colorConfig = colorConfig;
        this.settingsService = settingsService;
        this.tableActionService = new TableActionService(this.getActionMap(), this.getInputMap());
        this.setBackground(colorConfig.getTableBackground());
        this.setAutoCreateRowSorter(withRowSorter);
        this.setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(this::onSelect);
        this.setAutoResizeMode(2);
        this.setFillsViewportHeight(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    XTable.this.onPopupTriggered(e);
                } else if (e.getClickCount() == 2) {
                    XTable.this.onDoubleClick();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    XTable.this.onPopupTriggered(e);
                }
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    XTable.this.onHeaderPopupTriggered(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    XTable.this.onHeaderPopupTriggered(e);
                }
            }
        });
        this.configureActions();
        appPreferences.getShutdownHooks().add(this::onShutdown);
    }

    private void configureActions() {
        this.tableActionService.loadKeyboardMappings();
        this.tableActionService.getAction(TableActions.markSelected).setActionListener(actionEvent -> this.createMarkForSelection());
        this.tableActionService.getAction(TableActions.pageDown).setActionListener(actionEvent -> this.onPageDown());
        this.tableActionService.getAction(TableActions.pageUp).setActionListener(actionEvent -> this.onPageUp());
        this.tableActionService.getAction(TableActions.home).setActionListener(actionEvent -> this.onHome());
        this.tableActionService.getAction(TableActions.end).setActionListener(actionEvent -> this.onEnd());
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        boolean hasMarker = this.hasMarker(row);
        boolean isLeadSelection = this.getSelectionModel().getLeadSelectionIndex() == row;
        this.configureRendererComponent(row, column, (JComponent)component, this.isCellSelected(row, column), this.isFocusOwner(), hasMarker, isLeadSelection);
        return component;
    }

    protected void configureRendererComponent(int row, int column, JComponent component, boolean isSelected, boolean hasFocus, boolean hasMarker, boolean isLeadSelection) {
        component.setBorder(BorderFactory.createEmptyBorder());
        if (!isSelected) {
            component.setForeground(this.colorConfig.getTableForeground());
            if (!hasMarker) {
                component.setBackground(row % 2 == 0 || !this.isShowAlternateBackground() ? this.colorConfig.getTableBackground() : this.colorConfig.getTableAlternateBackground());
            } else {
                component.setForeground(this.colorConfig.getTableMarkForeground());
                component.setBackground(row % 2 == 0 ? this.colorConfig.getTableMarkBackground() : this.colorConfig.getTableMarkAlternateBackground());
            }
        } else {
            if (isLeadSelection && hasFocus) {
                Color color = this.colorConfig.getTableLeadSelectionBorderColor();
                MatteBorder border = column == 0 ? BorderFactory.createMatteBorder(1, 1, 1, 0, color) : (column == this.getColumnCount() - 1 ? BorderFactory.createMatteBorder(1, 0, 1, 1, color) : BorderFactory.createMatteBorder(1, 0, 1, 0, color));
                component.setBorder(border);
            }
            component.setForeground(this.colorConfig.getTableSelectionForeground());
            if (!hasMarker) {
                component.setBackground(hasFocus ? this.colorConfig.getTableSelectionBackground() : this.colorConfig.getTableSelectionNoFocusBackground());
            } else {
                component.setBackground(this.colorConfig.getTableMarkSelectedBackground());
            }
        }
    }

    private void onDoubleClick() {
        int[] selectedModelRows = this.getSelectedModelRowIndices();
        this.clickListeners.forEach(listener -> listener.accept(selectedModelRows));
    }

    private void onSelect(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            int[] selectedModelRows = this.getSelectedModelRowIndices();
            this.listSelectionListeners.forEach(listener -> listener.accept(selectedModelRows));
        }
    }

    public int[] getSelectedModelRowIndices() {
        return this.getSelectedRows() != null ? Arrays.stream(this.getSelectedRows()).map(this::getModelRowIndex).toArray() : null;
    }

    public int getSelectedModelRowIndex() {
        int rowIndex = this.getSelectedRow();
        return this.getModelRowIndex(rowIndex);
    }

    public int getModelRowIndex(int rowIndex) {
        return rowIndex > -1 ? (this.getRowSorter() != null ? this.getRowSorter().convertRowIndexToModel(rowIndex) : rowIndex) : -1;
    }

    public int getTableRowIndex(int modeLRowIndex) {
        return modeLRowIndex > -1 ? (this.getRowSorter() != null ? this.getRowSorter().convertRowIndexToView(modeLRowIndex) : modeLRowIndex) : -1;
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        if (dataModel instanceof AbstractXTableModel) {
            this.loadProperties(this.getTableModel());
        }
    }

    protected void loadProperties(AbstractXTableModel<T> tableModel) {
        TableColumnModel tableColumnModel;
        try {
            tableColumnModel = this.appPreferences.get(this.getPreferencesKey(tableModel.getTableId()), TableColumnModel.class);
        }
        catch (Exception e) {
            tableColumnModel = tableModel.getDefaultTableColumnModel();
        }
        this.createColumns(tableColumnModel);
        this.applyRowSorter(tableColumnModel);
    }

    protected void applyRowSorter(TableColumnModel tableColumnModel) {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter instanceof TableRowSorter) {
            TableRowSorter rowSorter2 = (TableRowSorter)rowSorter;
            rowSorter2.setSortKeys(tableColumnModel.getSortKeys() != null ? Arrays.stream(tableColumnModel.getSortKeys()).map(sortKey -> new RowSorter.SortKey(sortKey.getColumn(), sortKey.getSortOrder())).toList() : new ArrayList());
            rowSorter2.sort();
        }
    }

    protected void createColumns(TableColumnModel tableColumnModel) {
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        AbstractXTableModel<T> tableModel = this.getTableModel();
        for (int i = 0; i < tableColumnModel.getColumnWidths().length; ++i) {
            int modelIndex = tableColumnModel.getColumnOrder() != null && i < tableColumnModel.getColumnOrder().length ? tableColumnModel.getColumnOrder()[i] : i;
            int width = tableColumnModel.getColumnWidths()[i];
            columnModel.addColumn(XTable.createColumn(modelIndex, tableModel.getColumnName(modelIndex), width));
        }
        this.setColumnModel(columnModel);
    }

    public void storeProperties() {
        TableColumnModel tableColumnModel = this.captureTableColumnModel();
        this.appPreferences.put(this.getPreferencesKey(this.getTableModel().getTableId()), tableColumnModel);
    }

    protected TableColumnModel captureTableColumnModel() {
        ArrayList<TableColumn> currentColumnList = this.getCurrentColumnList();
        return TableColumnModel.builder().columnWidths(currentColumnList.stream().mapToInt(TableColumn::getWidth).toArray()).columnOrder(currentColumnList.stream().mapToInt(TableColumn::getModelIndex).toArray()).sortKeys(this.getRowSorter() != null ? (TableColumnModel.SortKey[])this.getRowSorter().getSortKeys().stream().map(sortKey -> TableColumnModel.SortKey.builder().column(sortKey.getColumn()).sortOrder(sortKey.getSortOrder()).build()).toArray(TableColumnModel.SortKey[]::new) : new TableColumnModel.SortKey[]{}).build();
    }

    protected String getPreferencesKey(String tableId) {
        return "table." + tableId;
    }

    private void onShutdown(AppPreferences appPreferences) {
        this.storeProperties();
    }

    private void onPopupTriggered(MouseEvent e) {
        JPopupMenu popupMenu;
        int rowIndex = this.rowAtPoint(e.getPoint());
        if (!this.isRowSelected(rowIndex)) {
            this.selectRow(rowIndex, false);
        }
        int popupMenuActionModelRowIndex = rowIndex > -1 ? this.getModelRowIndex(rowIndex) : -1;
        JPopupMenu jPopupMenu = popupMenu = this.tablePopupProvider != null ? this.tablePopupProvider.getPopupMenuFor(popupMenuActionModelRowIndex, this.getSelectedModelRowIndices()) : null;
        if (popupMenu != null) {
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void onHeaderPopupTriggered(MouseEvent e) {
        AbstractXTableModel<T> tableModel = this.getTableModel();
        JPopupMenu popupMenu = new JPopupMenu();
        ArrayList<TableColumn> columns = this.getCurrentColumnList();
        int i = 0;
        while (i < tableModel.getColumnCount()) {
            int modelIndex = i++;
            JCheckBoxMenuItem columnMenu = new JCheckBoxMenuItem(tableModel.getColumnName(modelIndex));
            columnMenu.setState(columns.stream().anyMatch(c -> c.getModelIndex() == modelIndex));
            columnMenu.addActionListener(actionEvent -> this.setColumnVisible(modelIndex, columnMenu.getState()));
            popupMenu.add(columnMenu);
        }
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void setColumnVisible(int modelIndex, boolean state) {
        if (state) {
            if (this.getCurrentColumnList().stream().noneMatch(c -> c.getModelIndex() == modelIndex)) {
                AbstractXTableModel<T> tableModel = this.getTableModel();
                int width = tableModel.getDefaultTableColumnModel().getColumnWidths()[modelIndex];
                this.columnModel.addColumn(XTable.createColumn(modelIndex, tableModel.getColumnName(modelIndex), width));
            }
        } else {
            this.getCurrentColumnList().stream().filter(c -> c.getModelIndex() == modelIndex).findAny().ifPresent(this::removeColumn);
        }
    }

    private static TableColumn createColumn(int modelIndex, String title, int width) {
        TableColumn column = new TableColumn(modelIndex);
        column.setPreferredWidth(width);
        column.setHeaderValue(title);
        return column;
    }

    private ArrayList<TableColumn> getCurrentColumnList() {
        return Collections.list(this.getColumnModel().getColumns());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isShowAlternateBackground()) {
            int rows = this.getModel().getRowCount();
            int modelHeight = rows * this.getRowHeight();
            int currentRow = rows;
            while (modelHeight < this.getHeight()) {
                g.setColor(currentRow % 2 == 0 ? this.colorConfig.getTableBackground() : this.colorConfig.getTableAlternateBackground());
                g.fillRect(0, modelHeight, this.getWidth(), this.getRowHeight());
                modelHeight += this.getRowHeight();
                ++currentRow;
            }
        }
    }

    protected AbstractXTableModel<T> getTableModel() {
        return (AbstractXTableModel)this.getModel();
    }

    public void setTableModel(AbstractXTableModel<T> tableModel) {
        this.setModel(tableModel);
    }

    private boolean isShowAlternateBackground() {
        return Boolean.TRUE.equals(this.settingsService.getAppSettings().getGeneral().getShowAlternateTableColor());
    }

    private boolean hasMarker(int tableRowIndex) {
        Object rowId = this.getTableModel().getRowIdForModelRowIndex(this.getModelRowIndex(tableRowIndex));
        return this.markers.contains(rowId);
    }

    public void dumpModel() {
        log.info("Selection: {}", Arrays.stream(this.getSelectedModelRowIndices()).mapToObj(this.getTableModel()::getRowIdForModelRowIndex).toList());
        log.info("Marks: {}", this.markers);
    }

    public void createMarkForSelection() {
        int[] selectedTableRowIndices = this.getSelectedRows();
        if (selectedTableRowIndices != null && selectedTableRowIndices.length == 1) {
            int selectedTableRowIndex = selectedTableRowIndices[0];
            Object rowId = this.getTableModel().getRowIdForModelRowIndex(this.getModelRowIndex(selectedTableRowIndex));
            if (this.hasMarker(selectedTableRowIndex)) {
                this.markers.remove(rowId);
                this.fireMarkerChanged(null, rowId);
            } else {
                this.markers.add(rowId);
                this.fireMarkerChanged(rowId, null);
            }
            int modelRowIndex = this.getModelRowIndex(selectedTableRowIndex);
            this.getTableModel().fireTableRowsUpdated(modelRowIndex, modelRowIndex);
        }
    }

    private void fireMarkerChanged(Object rowIdAdded, Object rowIdRemoved) {
        this.markSelectionListeners.forEach(listener -> listener.accept(rowIdAdded, rowIdRemoved));
    }

    public void cacheSelection() {
        this.cachedSelection.clear();
        this.cachedSelection.addAll(Arrays.stream(this.getSelectedRows()).map(this::getModelRowIndex).mapToObj(this.getTableModel()::getRowIdForModelRowIndex).toList());
    }

    public void restoreSelection() {
        this.clearSelection();
        this.cachedSelection.forEach(rowId -> {
            int modelRowIndex = this.getTableModel().getModelRowIndexForRowId(rowId);
            if (modelRowIndex > -1) {
                int tableRowIndex = this.getTableRowIndex(modelRowIndex);
                this.getSelectionModel().addSelectionInterval(tableRowIndex, tableRowIndex);
            }
        });
    }

    public void clearTableState() {
        this.clearSelection();
        this.cachedSelection.clear();
        this.markers.clear();
        this.getTableModel().fireTableDataChanged();
    }

    public void selectRow(int row, boolean scrollToRow) {
        if (row >= this.getRowCount()) {
            row = this.getRowCount() - 1;
        }
        this.getSelectionModel().setSelectionInterval(row, row);
        if (scrollToRow) {
            this.scrollRectToVisible(this.getCellRect(row, 0, true));
        }
    }

    public TableSelection getSelection() {
        return TableSelection.builder().markedRowIds(new ArrayList<Object>(this.markers)).selectedRowIds(Arrays.stream(this.getSelectedModelRowIndices()).mapToObj(this.getTableModel()::getRowIdForModelRowIndex).toList()).build();
    }

    private void onPageDown() {
        Rectangle rect = this.getVisibleRect();
        int firstVisibleRow = this.rowAtPoint(rect.getLocation());
        int row = this.getRowCount() - 1;
        rect.translate(0, rect.height - 1);
        int lastVisibleRow = this.rowAtPoint(rect.getLocation());
        if (firstVisibleRow != -1 && lastVisibleRow != -1) {
            int visibleRows = lastVisibleRow - firstVisibleRow;
            row = this.getSelectionModel().getLeadSelectionIndex() + visibleRows;
            if (row >= this.getRowCount()) {
                row = this.getRowCount() - 1;
            }
        }
        this.selectRow(row, true);
    }

    private void onPageUp() {
        Rectangle rect = this.getVisibleRect();
        int firstVisibleRow = this.rowAtPoint(rect.getLocation());
        int row = 0;
        rect.translate(0, rect.height - 1);
        int lastVisibleRow = this.rowAtPoint(rect.getLocation());
        if (firstVisibleRow != -1 && lastVisibleRow != -1) {
            int visibleRows = lastVisibleRow - firstVisibleRow;
            row = this.getSelectionModel().getLeadSelectionIndex() - visibleRows;
            if (row < 0) {
                row = 0;
            }
        }
        this.selectRow(row, true);
    }

    private void onHome() {
        if (this.getRowCount() > 0) {
            this.selectRow(0, true);
        }
    }

    private void onEnd() {
        if (this.getRowCount() > 0) {
            this.selectRow(this.getRowCount() - 1, true);
        }
    }

    @Generated
    public I18nService getI18n() {
        return this.i18n;
    }

    @Generated
    public List<Consumer<int[]>> getListSelectionListeners() {
        return this.listSelectionListeners;
    }

    @Generated
    public List<Consumer<int[]>> getClickListeners() {
        return this.clickListeners;
    }

    @Generated
    public List<BiConsumer<Object, Object>> getMarkSelectionListeners() {
        return this.markSelectionListeners;
    }

    @Generated
    public void setTablePopupProvider(TablePopupProvider tablePopupProvider) {
        this.tablePopupProvider = tablePopupProvider;
    }
}

