/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.general.xtable;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import lombok.Generated;
import net.schembs.solutions.desktopclient.model.TableRowIdProvider;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.general.xtable.TableColumnModel;

public abstract class AbstractXTableModel<T extends TableRowIdProvider>
extends AbstractTableModel {
    private final I18nService i18n;
    protected final List<T> rows = new ArrayList<T>();

    public AbstractXTableModel(I18nService i18n) {
        this.i18n = i18n;
    }

    public abstract String getTableId();

    public abstract TableColumnModel getDefaultTableColumnModel();

    public abstract List<String> getColumnTitles();

    @Override
    public String getColumnName(int column) {
        return this.i18n.t(this.getColumnTitles().get(column), new Object[0]);
    }

    public Object getRowIdForModelRowIndex(int modelRowIndex) {
        return ((TableRowIdProvider)this.rows.get(modelRowIndex)).getRowId();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public int getModelRowIndexForRowId(Object rowId) {
        return this.rows.stream().filter(row -> row.getRowId().equals(rowId)).findFirst().map(this.rows::indexOf).orElse(-1);
    }

    @Generated
    public I18nService getI18n() {
        return this.i18n;
    }

    @Generated
    public List<T> getRows() {
        return this.rows;
    }
}

