/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.general.settings.editors;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lombok.Generated;
import net.schembs.solutions.desktopclient.IllegalSettingPath;
import net.schembs.solutions.desktopclient.model.BasicAppSettings;
import net.schembs.solutions.desktopclient.service.ComponentHelper;
import net.schembs.solutions.desktopclient.service.SimpleAction;
import net.schembs.solutions.desktopclient.ui.KeyboardHelper;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.CheckBoxSettingEditor;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.DropDownSettingEditor;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.DropDownValue;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.IntTextFieldSettingEditor;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.SettingEditor;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.StringTextFieldSettingEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SettingEditorHelper<T extends BasicAppSettings> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SettingEditorHelper.class);
    private final Map<String, SettingEditor> editors = new HashMap<String, SettingEditor>();
    private T settings;

    public SettingEditor configureAsFirst(SettingEditor component, Supplier<Runnable> excecuteOnLeaveTopProvider) {
        this.configureAsFirst(component.getComponent(), excecuteOnLeaveTopProvider);
        return component;
    }

    public void configureAsFirst(JComponent component, Supplier<Runnable> excecuteOnLeaveTopProvider) {
        KeyboardHelper.registerActionOnComponent(component, KeyboardHelper.getKeyStrokeForMapping("cmd up"), new SimpleAction(excecuteOnLeaveTopProvider));
    }

    public SettingEditor configureAsLast(SettingEditor component) {
        component.getEditorComponent().getInputMap().remove(KeyboardHelper.getKeyStrokeForMapping("cmd down"));
        return component;
    }

    public SettingEditor createCheckBox(JPanel parent, String title, String message, String modelPath) {
        parent.add(this.createTitle(title));
        CheckBoxSettingEditor checkBox = new CheckBoxSettingEditor(message, value -> this.onComponentValueChanged(modelPath, value));
        this.configureEditor(parent, checkBox, modelPath);
        return checkBox;
    }

    public SettingEditor createDropDown(JPanel parent, String title, String modelPath, List<DropDownValue> dropDownValues) {
        parent.add(this.createTitle(title));
        DropDownSettingEditor dropDown = new DropDownSettingEditor(dropDownValues, value -> this.onComponentValueChanged(modelPath, value));
        this.configureEditor(parent, dropDown, modelPath);
        parent.add(dropDown);
        return dropDown;
    }

    public SettingEditor createStringTextField(JPanel parent, String title, String postfix, int columns, String modelPath) {
        parent.add(this.createTitle(title));
        StringTextFieldSettingEditor textField = new StringTextFieldSettingEditor(columns, value -> this.onComponentValueChanged(modelPath, value));
        textField.setPostFix(postfix);
        this.configureEditor(parent, textField, modelPath);
        return textField;
    }

    public SettingEditor createIntTextField(JPanel parent, String title, String postfix, int columns, String modelPath) {
        parent.add(this.createTitle(title));
        IntTextFieldSettingEditor textField = new IntTextFieldSettingEditor(columns, value -> this.onComponentValueChanged(modelPath, value));
        textField.setPostFix(postfix);
        this.configureEditor(parent, textField, modelPath);
        return textField;
    }

    private void configureEditor(JPanel parent, SettingEditor editor, String modelPath) {
        this.editors.put(modelPath, editor);
        KeyboardHelper.registerActionOnComponent(editor.getEditorComponent(), "cmd up", KeyboardFocusManager.getCurrentKeyboardFocusManager()::focusPreviousComponent);
        KeyboardHelper.registerActionOnComponent(editor.getEditorComponent(), "cmd down", KeyboardFocusManager.getCurrentKeyboardFocusManager()::focusNextComponent);
        ComponentHelper.registerClose(editor.getEditorComponent());
        parent.add(editor.getComponent());
    }

    private void onComponentValueChanged(String modelPath, Object value) {
        this.setValueForPath(modelPath, value);
    }

    private Component createTitle(String title) {
        JLabel titleLabel = new JLabel((String)(!title.isEmpty() ? title + ":" : ""));
        titleLabel.setHorizontalAlignment(4);
        return titleLabel;
    }

    public void setSettings(T settings) {
        this.settings = settings;
        this.applyValuesToEditors(settings);
    }

    private void applyValuesToEditors(T settings) {
        for (Map.Entry<String, SettingEditor> entry : this.editors.entrySet()) {
            this.applyValue(settings, entry.getKey(), entry.getValue());
        }
    }

    private void applyValue(T settings, String modelPath, SettingEditor editor) {
        ArrayList<String> pathComponents = new ArrayList<String>(Arrays.asList(modelPath.split("\\.")));
        Object value = this.getValueForPath(settings, pathComponents);
        editor.setValue(value);
    }

    private Object getValueForPath(Object object, List<String> pathComponents) {
        if (pathComponents.isEmpty() || object == null) {
            return object;
        }
        String currentPath = pathComponents.removeFirst();
        Method m = ReflectionUtils.findMethod(object.getClass(), (String)("get" + StringUtils.capitalize((String)currentPath)));
        if (m == null) {
            m = ReflectionUtils.findMethod(object.getClass(), (String)("is" + StringUtils.capitalize((String)currentPath)));
        }
        try {
            object = m.invoke(object, new Object[0]);
            return this.getValueForPath(object, pathComponents);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalSettingPath("Missing path " + currentPath + " on " + String.valueOf(object));
        }
    }

    private void setValueForPath(String modelPath, Object value) {
        ArrayList<String> pathComponents = new ArrayList<String>(Arrays.asList(modelPath.split("\\.")));
        String setter = (String)pathComponents.removeLast();
        Object object = this.getValueForPath(this.settings, pathComponents);
        Method m = ReflectionUtils.findMethod(object.getClass(), (String)("set" + StringUtils.capitalize((String)setter)), (Class[])new Class[]{value.getClass()});
        if (m == null) {
            throw new IllegalSettingPath("Missing setter " + setter + " on " + String.valueOf(object));
        }
        try {
            m.invoke(object, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalSettingPath("Missing setter " + setter + " on " + String.valueOf(object));
        }
    }
}

