/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.general.settings.editors;

import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.DropDownValue;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.SettingEditor;

public class DropDownSettingEditor
extends JComboBox<DropDownValue>
implements SettingEditor {
    private boolean isAdjusting = false;
    private final Consumer<String> valueConsumer;

    public DropDownSettingEditor(List<DropDownValue> values, Consumer<String> valueConsumer) {
        super(values.toArray(new DropDownValue[0]));
        this.valueConsumer = valueConsumer;
        this.addActionListener(actionEvent -> {
            if (!this.isAdjusting) {
                this.onSelectionChanged();
            }
        });
    }

    private void onSelectionChanged() {
        DropDownValue item = (DropDownValue)this.getSelectedItem();
        this.valueConsumer.accept(item != null ? item.getValue() : null);
    }

    @Override
    public void setValue(Object value) {
        try {
            this.isAdjusting = true;
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!((DropDownValue)this.getItemAt(i)).getValue().equals(value)) continue;
                this.setSelectedIndex(i);
                return;
            }
        }
        finally {
            this.isAdjusting = false;
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public JComponent getEditorComponent() {
        return this;
    }
}

