/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.general.settings.editors;

import java.awt.FlowLayout;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.SettingEditor;

public abstract class AbstractTextFieldSettingEditor<T>
extends JPanel
implements SettingEditor {
    protected final Consumer<T> valueConsumer;
    protected JTextField textField;
    private final JLabel postFixLabel;
    private boolean isAdjusting = false;

    public AbstractTextFieldSettingEditor(int columns, Consumer<T> valueConsumer) {
        super(new FlowLayout(3, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.valueConsumer = valueConsumer;
        this.textField = new JTextField(columns);
        this.add(this.textField);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!AbstractTextFieldSettingEditor.this.isAdjusting) {
                    AbstractTextFieldSettingEditor.this.onDocumentChanged();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!AbstractTextFieldSettingEditor.this.isAdjusting) {
                    AbstractTextFieldSettingEditor.this.onDocumentChanged();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!AbstractTextFieldSettingEditor.this.isAdjusting) {
                    AbstractTextFieldSettingEditor.this.onDocumentChanged();
                }
            }
        });
        this.add(Box.createHorizontalStrut(4));
        this.postFixLabel = new JLabel("");
        this.add(this.postFixLabel);
    }

    protected abstract void onDocumentChanged();

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void setPostFix(String postFix) {
        this.postFixLabel.setText(postFix);
    }

    @Override
    public void setValue(Object value) {
        this.isAdjusting = true;
        this.textField.setText(value != null ? value.toString() : "");
        this.isAdjusting = false;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.textField;
    }
}

