/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.general.settings;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jiconfont.IconCode;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.model.BasicAppSettings;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.UIUtils;
import net.schembs.solutions.desktopclient.ui.general.settings.CategoryAction;
import net.schembs.solutions.desktopclient.ui.general.settings.CategoryButton;
import net.schembs.solutions.desktopclient.ui.general.settings.CategorySelectionListener;
import net.schembs.solutions.desktopclient.ui.general.settings.SettingsCategoryPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsPanel<T extends BasicAppSettings>
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SettingsPanel.class);
    private final UIUtils uiUtils;
    private final ColorConfig colorConfig;
    private final I18nService i18n;
    private JPanel categoryButtonsHolder;
    private JPanel categoryHolder;
    private final Map<String, SettingsCategoryPanel<T>> categoryPanels = new HashMap<String, SettingsCategoryPanel<T>>();
    private final Map<String, CategoryButton> categoryButtons = new HashMap<String, CategoryButton>();
    private JComponent firstButton;
    private JComponent lastButton;
    private CategorySelectionListener<T> categorySelectionListener;
    private SettingsCategoryPanel<T> currentCategoryPanel;
    private CategoryButton currentCategoryButton;

    @PostConstruct
    public void createUI() {
        this.setLayout(new BorderLayout());
        this.categoryButtonsHolder = new JPanel(new FlowLayout(1, 24, 0));
        this.categoryButtonsHolder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.categoryButtonsHolder.setBackground(this.colorConfig.getBarBackground());
        this.categoryButtonsHolder.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, this.colorConfig.getSeparatorColor()), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.add((Component)this.categoryButtonsHolder, "North");
        this.categoryHolder = new JPanel(new BorderLayout());
        this.categoryHolder.setBackground(this.colorConfig.getBarBackground());
        this.categoryHolder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.categoryHolder, "Center");
    }

    private CategoryButton createCategoryButton(String action, IconCode icon, String name) {
        CategoryButton categoryButton = new CategoryButton(action, this.uiUtils.getFontIcon(icon, 32, this.colorConfig.getShyLabelForeground()), name, CategoryButton.CategoryButtonColors.builder().focus(this.colorConfig.getFocusMarker()).foreground(this.colorConfig.getShyLabelForeground()).selected(this.colorConfig.getShyLabelForeground()).build());
        categoryButton.getActionListeners().add(categoryAction -> this.onCategoryAction(action, (CategoryAction)((Object)categoryAction)));
        return categoryButton;
    }

    public void onCategoryAction(String action, CategoryAction categoryAction) {
        switch (categoryAction) {
            case select: {
                this.selectCategory(action);
                break;
            }
            case focusPanel: {
                this.onCurrentPanelRequestFocus();
                break;
            }
            case focusNext: {
                this.onFocusNextCategory();
                break;
            }
            case focusPrevious: {
                this.onFocusPreviousCategory();
            }
        }
    }

    private void onFocusPreviousCategory() {
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() != this.firstButton) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
        }
    }

    private void onFocusNextCategory() {
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() != this.lastButton) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
        }
    }

    private void onCurrentPanelRequestFocus() {
        this.currentCategoryPanel.requestFocusOnFirstComponent();
    }

    public void registerCategory(Enum<?> categoryName, IconCode icon, SettingsCategoryPanel<T> categoryPanel) {
        this.registerCategory(categoryName.name(), icon, this.i18n.t(categoryName.toString(), new Object[0]), categoryPanel);
    }

    public void registerCategory(String categoryName, IconCode icon, String title, SettingsCategoryPanel<T> categoryPanel) {
        this.categoryPanels.put(categoryName, categoryPanel);
        categoryPanel.setFocusOnMenuRequester(this::onRequestFocusOnMenu);
        CategoryButton categoryButton = this.createCategoryButton(categoryName, icon, title);
        if (this.firstButton == null) {
            this.firstButton = categoryButton;
        }
        this.lastButton = categoryButton;
        this.categoryButtons.put(categoryName, categoryButton);
        this.categoryButtonsHolder.add(categoryButton);
    }

    private void onRequestFocusOnMenu() {
        if (this.currentCategoryButton != null) {
            this.currentCategoryButton.requestFocus();
        } else if (this.firstButton != null) {
            this.firstButton.requestFocus();
        }
    }

    public void selectCategory(Enum<?> category) {
        this.selectCategory(category.name());
    }

    public void selectCategory(String category) {
        this.categoryHolder.removeAll();
        if (this.currentCategoryButton != null) {
            this.currentCategoryButton.setSelected(false);
        }
        this.currentCategoryPanel = this.categoryPanels.get(category);
        this.categorySelectionListener.onPrepareCategoryPanel(this.currentCategoryPanel);
        this.categoryHolder.add((Component)this.currentCategoryPanel.getPanel(), "Center");
        this.currentCategoryButton = this.categoryButtons.get(category);
        this.currentCategoryButton.setSelected(true);
        this.revalidate();
        this.repaint();
        this.categorySelectionListener.onCategorySelected(category);
    }

    @Generated
    public SettingsPanel(UIUtils uiUtils, ColorConfig colorConfig, I18nService i18n) {
        this.uiUtils = uiUtils;
        this.colorConfig = colorConfig;
        this.i18n = i18n;
    }

    @Generated
    public void setCategorySelectionListener(CategorySelectionListener<T> categorySelectionListener) {
        this.categorySelectionListener = categorySelectionListener;
    }
}

