/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.general.settings;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import net.schembs.solutions.desktopclient.ui.general.RoundedBorder;
import net.schembs.solutions.desktopclient.ui.general.settings.CategoryAction;
import net.schembs.solutions.desktopclient.ui.layout.VerticalLayout;

public class CategoryButton
extends JPanel {
    private final List<Consumer<CategoryAction>> actionListeners = new ArrayList<Consumer<CategoryAction>>();
    private final CategoryButtonColors colors;
    private boolean isSelected = false;
    private boolean isFocused = false;

    public CategoryButton(String name, ImageIcon icon, String title, CategoryButtonColors colors) {
        this.colors = colors;
        this.setName(name);
        this.setFocusable(true);
        this.setLayout(new VerticalLayout(0));
        this.setOpaque(false);
        this.add(new JLabel(icon));
        JLabel label = new JLabel(title);
        label.setForeground(colors.getForeground());
        this.add(label);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CategoryButton.this.onSelectCategory();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    CategoryButton.this.onSelectCategory();
                }
                if (e.getKeyCode() == 40) {
                    CategoryButton.this.publishAction(CategoryAction.focusPanel);
                }
                if (e.getKeyCode() == 37) {
                    CategoryButton.this.publishAction(CategoryAction.focusPrevious);
                }
                if (e.getKeyCode() == 39) {
                    CategoryButton.this.publishAction(CategoryAction.focusNext);
                }
                if (e.getKeyCode() == 27) {
                    SwingUtilities.getWindowAncestor(CategoryButton.this).setVisible(false);
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CategoryButton.this.isFocused = true;
                CategoryButton.this.updateBorder();
            }

            @Override
            public void focusLost(FocusEvent e) {
                CategoryButton.this.isFocused = false;
                CategoryButton.this.updateBorder();
            }
        });
        this.isFocused = false;
        this.updateBorder();
    }

    public void updateBorder() {
        Border innerBorder = BorderFactory.createEmptyBorder(7, 7, 7, 7);
        if (this.isSelected) {
            innerBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createCompoundBorder(new RoundedBorder(this.colors.selected, 16, false), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        }
        this.setBorder(BorderFactory.createCompoundBorder(this.isFocused ? new RoundedBorder(this.colors.focus, 16, true) : BorderFactory.createEmptyBorder(1, 1, 1, 1), innerBorder));
    }

    private void onSelectCategory() {
        this.publishAction(CategoryAction.select);
    }

    private void publishAction(CategoryAction action) {
        this.actionListeners.forEach(listener -> listener.accept(action));
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
        this.updateBorder();
    }

    @Generated
    public List<Consumer<CategoryAction>> getActionListeners() {
        return this.actionListeners;
    }

    public static class CategoryButtonColors {
        private Color foreground;
        private Color focus;
        private Color selected;

        @Generated
        CategoryButtonColors(Color foreground, Color focus, Color selected) {
            this.foreground = foreground;
            this.focus = focus;
            this.selected = selected;
        }

        @Generated
        public static CategoryButtonColorsBuilder builder() {
            return new CategoryButtonColorsBuilder();
        }

        @Generated
        public Color getForeground() {
            return this.foreground;
        }

        @Generated
        public Color getFocus() {
            return this.focus;
        }

        @Generated
        public Color getSelected() {
            return this.selected;
        }

        @Generated
        public void setForeground(Color foreground) {
            this.foreground = foreground;
        }

        @Generated
        public void setFocus(Color focus) {
            this.focus = focus;
        }

        @Generated
        public void setSelected(Color selected) {
            this.selected = selected;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CategoryButtonColors)) {
                return false;
            }
            CategoryButtonColors other = (CategoryButtonColors)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Color this$foreground = this.getForeground();
            Color other$foreground = other.getForeground();
            if (this$foreground == null ? other$foreground != null : !((Object)this$foreground).equals(other$foreground)) {
                return false;
            }
            Color this$focus = this.getFocus();
            Color other$focus = other.getFocus();
            if (this$focus == null ? other$focus != null : !((Object)this$focus).equals(other$focus)) {
                return false;
            }
            Color this$selected = this.getSelected();
            Color other$selected = other.getSelected();
            return !(this$selected == null ? other$selected != null : !((Object)this$selected).equals(other$selected));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CategoryButtonColors;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Color $foreground = this.getForeground();
            result = result * 59 + ($foreground == null ? 43 : ((Object)$foreground).hashCode());
            Color $focus = this.getFocus();
            result = result * 59 + ($focus == null ? 43 : ((Object)$focus).hashCode());
            Color $selected = this.getSelected();
            result = result * 59 + ($selected == null ? 43 : ((Object)$selected).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CategoryButton.CategoryButtonColors(foreground=" + String.valueOf(this.getForeground()) + ", focus=" + String.valueOf(this.getFocus()) + ", selected=" + String.valueOf(this.getSelected()) + ")";
        }

        @Generated
        public static class CategoryButtonColorsBuilder {
            @Generated
            private Color foreground;
            @Generated
            private Color focus;
            @Generated
            private Color selected;

            @Generated
            CategoryButtonColorsBuilder() {
            }

            @Generated
            public CategoryButtonColorsBuilder foreground(Color foreground) {
                this.foreground = foreground;
                return this;
            }

            @Generated
            public CategoryButtonColorsBuilder focus(Color focus) {
                this.focus = focus;
                return this;
            }

            @Generated
            public CategoryButtonColorsBuilder selected(Color selected) {
                this.selected = selected;
                return this;
            }

            @Generated
            public CategoryButtonColors build() {
                return new CategoryButtonColors(this.foreground, this.focus, this.selected);
            }

            @Generated
            public String toString() {
                return "CategoryButton.CategoryButtonColors.CategoryButtonColorsBuilder(foreground=" + String.valueOf(this.foreground) + ", focus=" + String.valueOf(this.focus) + ", selected=" + String.valueOf(this.selected) + ")";
            }
        }
    }
}

