/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.general;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.AppAction;

public class ToolbarIconButton
extends JLabel {
    private ActionListener actionListener;
    private boolean isHovered = false;
    private ToolbarIconButtonColors colors;
    private Icon icon;
    private Icon hoverIcon;
    private String badge;

    public ToolbarIconButton(Icon imageIcon, Icon hoverIcon, ToolbarIconButtonColors colors, String tooltip, final AppAction action) {
        super(imageIcon);
        this.icon = imageIcon;
        this.hoverIcon = hoverIcon;
        this.colors = colors;
        this.setToolTipText(tooltip);
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ToolbarIconButton this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.this$0.actionListener != null) {
                    this.this$0.actionListener.actionPerformed(new ActionEvent(this.this$0, 1001, "ButtonClick"));
                }
                if (action != null) {
                    action.actionPerformed(new ActionEvent(this.this$0, 1001, "ButtonClick"));
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.this$0.isHovered = true;
                this.this$0.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.this$0.isHovered = false;
                this.this$0.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.drawHoverBackground(g);
        super.paintComponent(g);
        this.drawBadge((Graphics2D)g);
    }

    private void drawHoverBackground(Graphics g) {
        if (this.isHovered) {
            this.setIcon(this.hoverIcon);
            g.setColor(this.colors.getHoverBackground());
            g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 30, 30);
        } else {
            this.setIcon(this.icon);
        }
    }

    private void drawBadge(Graphics2D g) {
        if (this.badge != null && !this.badge.isEmpty()) {
            g.setFont(this.getFont().deriveFont(9.0f));
            FontMetrics fontMetrics = g.getFontMetrics();
            int paddingX = 2;
            int paddingY = 1;
            int badgeWidth = fontMetrics.stringWidth(this.badge) + paddingX * 2;
            int badgeHeight = fontMetrics.getHeight() + paddingY * 2;
            int xDelta = 0;
            if (badgeWidth < badgeHeight) {
                xDelta = (badgeHeight - badgeWidth) / 2;
                badgeWidth = badgeHeight;
            }
            int badgeX = this.getWidth() - badgeWidth;
            int badgeY = this.getHeight() - badgeHeight;
            g.setColor(this.colors.getBadgeBackground());
            g.fillOval(badgeX, badgeY, badgeWidth, badgeHeight);
            g.setColor(this.colors.getBadgeForeground());
            g.drawString(this.badge, badgeX + paddingX + xDelta, badgeY + paddingY + fontMetrics.getAscent());
        }
    }

    public void setBadge(String badge) {
        this.badge = badge;
        this.revalidate();
        this.repaint();
    }

    @Generated
    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public static class ToolbarIconButtonColors {
        private Color hoverBackground;
        private Color badgeBackground;
        private Color badgeForeground;

        @Generated
        ToolbarIconButtonColors(Color hoverBackground, Color badgeBackground, Color badgeForeground) {
            this.hoverBackground = hoverBackground;
            this.badgeBackground = badgeBackground;
            this.badgeForeground = badgeForeground;
        }

        @Generated
        public static ToolbarIconButtonColorsBuilder builder() {
            return new ToolbarIconButtonColorsBuilder();
        }

        @Generated
        public Color getHoverBackground() {
            return this.hoverBackground;
        }

        @Generated
        public Color getBadgeBackground() {
            return this.badgeBackground;
        }

        @Generated
        public Color getBadgeForeground() {
            return this.badgeForeground;
        }

        @Generated
        public void setHoverBackground(Color hoverBackground) {
            this.hoverBackground = hoverBackground;
        }

        @Generated
        public void setBadgeBackground(Color badgeBackground) {
            this.badgeBackground = badgeBackground;
        }

        @Generated
        public void setBadgeForeground(Color badgeForeground) {
            this.badgeForeground = badgeForeground;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ToolbarIconButtonColors)) {
                return false;
            }
            ToolbarIconButtonColors other = (ToolbarIconButtonColors)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Color this$hoverBackground = this.getHoverBackground();
            Color other$hoverBackground = other.getHoverBackground();
            if (this$hoverBackground == null ? other$hoverBackground != null : !((Object)this$hoverBackground).equals(other$hoverBackground)) {
                return false;
            }
            Color this$badgeBackground = this.getBadgeBackground();
            Color other$badgeBackground = other.getBadgeBackground();
            if (this$badgeBackground == null ? other$badgeBackground != null : !((Object)this$badgeBackground).equals(other$badgeBackground)) {
                return false;
            }
            Color this$badgeForeground = this.getBadgeForeground();
            Color other$badgeForeground = other.getBadgeForeground();
            return !(this$badgeForeground == null ? other$badgeForeground != null : !((Object)this$badgeForeground).equals(other$badgeForeground));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ToolbarIconButtonColors;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Color $hoverBackground = this.getHoverBackground();
            result = result * 59 + ($hoverBackground == null ? 43 : ((Object)$hoverBackground).hashCode());
            Color $badgeBackground = this.getBadgeBackground();
            result = result * 59 + ($badgeBackground == null ? 43 : ((Object)$badgeBackground).hashCode());
            Color $badgeForeground = this.getBadgeForeground();
            result = result * 59 + ($badgeForeground == null ? 43 : ((Object)$badgeForeground).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ToolbarIconButton.ToolbarIconButtonColors(hoverBackground=" + String.valueOf(this.getHoverBackground()) + ", badgeBackground=" + String.valueOf(this.getBadgeBackground()) + ", badgeForeground=" + String.valueOf(this.getBadgeForeground()) + ")";
        }

        @Generated
        public static class ToolbarIconButtonColorsBuilder {
            @Generated
            private Color hoverBackground;
            @Generated
            private Color badgeBackground;
            @Generated
            private Color badgeForeground;

            @Generated
            ToolbarIconButtonColorsBuilder() {
            }

            @Generated
            public ToolbarIconButtonColorsBuilder hoverBackground(Color hoverBackground) {
                this.hoverBackground = hoverBackground;
                return this;
            }

            @Generated
            public ToolbarIconButtonColorsBuilder badgeBackground(Color badgeBackground) {
                this.badgeBackground = badgeBackground;
                return this;
            }

            @Generated
            public ToolbarIconButtonColorsBuilder badgeForeground(Color badgeForeground) {
                this.badgeForeground = badgeForeground;
                return this;
            }

            @Generated
            public ToolbarIconButtonColors build() {
                return new ToolbarIconButtonColors(this.hoverBackground, this.badgeBackground, this.badgeForeground);
            }

            @Generated
            public String toString() {
                return "ToolbarIconButton.ToolbarIconButtonColors.ToolbarIconButtonColorsBuilder(hoverBackground=" + String.valueOf(this.hoverBackground) + ", badgeBackground=" + String.valueOf(this.badgeBackground) + ", badgeForeground=" + String.valueOf(this.badgeForeground) + ")";
            }
        }
    }
}

