/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.general;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.I18nService;

public class OkCancelDialog
extends JDialog {
    private boolean canceled;
    private final I18nService i18n;
    private JButton okButton;

    public OkCancelDialog(Window parent, I18nService i18n) {
        super(parent);
        this.i18n = i18n;
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
    }

    public void createUI() {
        this.canceled = true;
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout());
        this.okButton = new JButton(this.i18n.t("button.ok", new Object[0]));
        this.okButton.addActionListener(e -> {
            this.canceled = false;
            this.setVisible(false);
        });
        JButton cancelButton = new JButton(this.i18n.t("button.cancel", new Object[0]));
        cancelButton.addActionListener(e -> this.setVisible(false));
        btnPanel.add(this.okButton);
        btnPanel.add(cancelButton);
        this.getContentPane().add((Component)btnPanel, "South");
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public void center() {
        int x = this.getParent().getX() + (this.getParent().getWidth() - this.getWidth()) / 2;
        int y = this.getParent().getY() + (this.getParent().getHeight() - this.getHeight()) / 2;
        this.setLocation(x, y);
    }

    public void setOkButtonEnabled(boolean enabled) {
        this.okButton.setEnabled(enabled);
    }

    @Generated
    public boolean isCanceled() {
        return this.canceled;
    }
}

