/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.general;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.model.RectangleWrapper;
import net.schembs.solutions.desktopclient.ui.general.AbstractAppDelegate;
import net.schembs.solutions.desktopclient.ui.general.MainFrame;
import net.schembs.solutions.desktopclient.ui.layout.AppLayoutBuilder;
import net.schembs.solutions.desktopclient.ui.osspecific.MainFrameConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMainFrame
extends JFrame
implements MainFrame,
AppLayoutBuilder.AppToolBarProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMainFrame.class);
    private static final String PREF_KEY = "mainFrame.bounds";
    private final AppPreferences appPreferences;
    private final AbstractAppDelegate appDelegate;
    private final MainFrameConfigurator mainFrameConfigurator;
    private final AppLayoutBuilder appLayoutBuilder;
    private final JPanel mainPanel = new JPanel(new BorderLayout());

    @PostConstruct
    public void createUI() {
        this.appDelegate.setMainFrame(this);
        this.appPreferences.getShutdownHooks().add(this::onShutdown);
        this.appLayoutBuilder.setAppToolBarProvider(this);
        this.mainFrameConfigurator.createUI(this, this.appDelegate);
        this.getContentPane().setLayout(new BorderLayout());
        this.setJMenuBar(this.createMenuBar());
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    protected abstract JMenuBar createMenuBar();

    @Override
    public void initUI() {
        this.loadProperties();
        this.appDelegate.initUI();
    }

    @Override
    public void showMainFrame() {
        this.setVisible(true);
    }

    @Override
    public void closeMainFrame() {
        this.appPreferences.shutdown();
        System.exit(0);
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    private void onShutdown(AppPreferences appPreferences) {
        this.storeProperties();
    }

    private void loadProperties() {
        try {
            this.setBounds(this.appPreferences.get(PREF_KEY, RectangleWrapper.class).asRectangle());
        }
        catch (Exception e) {
            log.warn("Failed to load mainFrame properties; defaulting.", (Throwable)e);
            this.setBounds(0, 0, 800, 600);
        }
    }

    private void storeProperties() {
        Rectangle bounds = this.getCurrentBounds();
        if (bounds != null) {
            this.appPreferences.put(PREF_KEY, new RectangleWrapper(bounds));
        }
    }

    protected Rectangle getCurrentBounds() {
        return this.mainFrameConfigurator.getCurrentBounds(this);
    }

    @Override
    public JComponent getLayoutToolBar(String layoutName) {
        return null;
    }

    @Generated
    public AbstractMainFrame(AppPreferences appPreferences, AbstractAppDelegate appDelegate, MainFrameConfigurator mainFrameConfigurator, AppLayoutBuilder appLayoutBuilder) {
        this.appPreferences = appPreferences;
        this.appDelegate = appDelegate;
        this.mainFrameConfigurator = mainFrameConfigurator;
        this.appLayoutBuilder = appLayoutBuilder;
    }

    @Override
    @Generated
    public JPanel getMainPanel() {
        return this.mainPanel;
    }
}

