/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui.general;

import jakarta.annotation.PostConstruct;
import javax.swing.FocusManager;
import javax.swing.JOptionPane;
import lombok.Generated;
import net.schembs.solutions.desktopclient.model.BasicAppSettings;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.ui.general.AbstractAboutWindow;
import net.schembs.solutions.desktopclient.ui.general.AppDelegate;
import net.schembs.solutions.desktopclient.ui.general.MainFrame;

public abstract class AbstractAppDelegate
implements AppDelegate {
    private final SettingsService<? extends BasicAppSettings> settingsService;
    private final I18nService i18n;
    private final AbstractAboutWindow aboutWindow;
    private MainFrame mainFrame;

    @Override
    @PostConstruct
    public void init() {
        this.configureActions();
    }

    protected abstract void configureActions();

    @Override
    public void onPrepareClose() {
        if (this.confirmClose()) {
            this.mainFrame.closeMainFrame();
        }
    }

    private boolean confirmClose() {
        return Boolean.FALSE.equals(this.settingsService.getAppSettings().getGeneral().getConfirmClose()) || JOptionPane.showConfirmDialog(this.mainFrame.getFrame(), this.i18n.t("confirm.close", new Object[0]), this.i18n.t("confirm.title", new Object[0]), 0) == 0;
    }

    @Override
    public void showAboutWindow() {
        this.processIfMainFrameInFocus(() -> this.aboutWindow.show(this.mainFrame.getFrame()));
    }

    protected void processIfMainFrameInFocus(Runnable runnable) {
        if (FocusManager.getCurrentManager().getActiveWindow() == this.mainFrame.getFrame()) {
            runnable.run();
        }
    }

    @Generated
    public AbstractAppDelegate(SettingsService<? extends BasicAppSettings> settingsService, I18nService i18n, AbstractAboutWindow aboutWindow) {
        this.settingsService = settingsService;
        this.i18n = i18n;
        this.aboutWindow = aboutWindow;
    }

    @Generated
    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    @Generated
    public MainFrame getMainFrame() {
        return this.mainFrame;
    }
}

