/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui;

import jakarta.annotation.PostConstruct;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import jiconfont.IconCode;
import jiconfont.IconFont;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.icons.google_material_design_icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.osspecific.UISystem;

public class UIUtils {
    private final I18nService i18n;
    private final ActionService actionService;
    private final ColorConfig colorConfig;

    @PostConstruct
    public void init() {
        IconFontSwing.register((IconFont)GoogleMaterialDesignIcons.getIconFont());
        IconFontSwing.register((IconFont)FontAwesome.getIconFont());
    }

    public JMenuItem getDelegateMenuItem(Enum<?> actionToExecute, Enum<?> textToShow, Object ... params) {
        JMenuItem item = new JMenuItem(this.actionService.getAction(actionToExecute));
        item.setText(this.i18n.t(textToShow.toString(), params));
        return item;
    }

    public ImageIcon getImageIcon(String name) {
        int dotPos = name.lastIndexOf(46);
        String ext = "";
        if (dotPos > 0) {
            ext = name.substring(dotPos);
            name = name.substring(0, dotPos);
        }
        String iconName = "/icons/" + name + "-" + (this.isDarkMode() ? "dark" : "light") + ext;
        URL resource = this.getClass().getResource(iconName);
        if (resource == null) {
            resource = this.getClass().getResource("/icons/" + name + ext);
        }
        return resource != null ? new ImageIcon(Toolkit.getDefaultToolkit().getImage(resource)) : null;
    }

    private boolean isDarkMode() {
        return UISystem.isDarkMode();
    }

    public JFrame findMainFrame(Component component) {
        if (component instanceof JFrame) {
            return (JFrame)component;
        }
        if (component != null) {
            return this.findMainFrame(component.getParent());
        }
        return null;
    }

    public ImageIcon getFontIcon(IconCode iconCode, int size) {
        return this.getFontIcon(iconCode, size, this.colorConfig.getLabelForeground());
    }

    public ImageIcon getFontIcon(IconCode iconCode, int size, Color color) {
        return (ImageIcon)IconFontSwing.buildIcon((IconCode)iconCode, (float)size, (Color)color);
    }

    @Generated
    public UIUtils(I18nService i18n, ActionService actionService, ColorConfig colorConfig) {
        this.i18n = i18n;
        this.actionService = actionService;
        this.colorConfig = colorConfig;
    }
}

