/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.ui;

import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import net.schembs.solutions.desktopclient.service.SimpleAction;

public class KeyboardHelper {
    public static JComponent registerActionOnComponent(JComponent component, String mapping, Runnable action) {
        return KeyboardHelper.registerActionOnComponent(component, KeyboardHelper.getKeyStrokeForMapping(mapping), new SimpleAction(() -> action));
    }

    public static JComponent registerActionOnComponent(JComponent component, KeyStroke keyStroke, Action action) {
        InputMap inputMap = component.getInputMap();
        if (component instanceof JTable) {
            inputMap = component.getInputMap(1);
        }
        if (component instanceof JRootPane) {
            inputMap = component.getInputMap(2);
        }
        inputMap.put(keyStroke, action.toString());
        component.getActionMap().put(action.toString(), action);
        return component;
    }

    public static KeyStroke getKeyStrokeForMapping(String mapping) {
        return KeyStroke.getKeyStroke(mapping.replaceAll("cmd", "meta").replaceAll("option", "alt").replaceAll("ctrl", "control").replaceAll("[Dd]el(ete)?", "DELETE").replaceAll("[Bb]ackspace", "BACK_SPACE").replaceAll("[Ss]pace", "SPACE").replaceAll("[Pp]age ?up", "PAGE_UP").replaceAll("[Pp]age ?down", "PAGE_DOWN").replaceAll("[Uu]p", "UP").replaceAll("[Dd]own", "DOWN").replaceAll("[Ll]eft", "LEFT").replaceAll("[Rr]ight", "RIGHT").replaceAll("[Ee]nter", "ENTER").replaceAll("[Ee]sc(ape)?", "ESCAPE").replaceAll("[Hh]ome", "HOME").replaceAll("[Ee]nd", "END").replaceAll("[Cc]omma", "COMMA").replaceAll("[Tt]ab", "TAB"));
    }
}

