/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.service;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.model.BasicAppSettings;

public class SettingsService<T extends BasicAppSettings> {
    public static final String PREF_KEY_SETTINGS = "settings";
    private final AppPreferences appPreferences;
    private final Class<T> settingsClazz;
    private final Supplier<T> defaultPreferencesSupplier;
    private final List<Consumer<T>> settingsChangedListeners = new ArrayList<Consumer<T>>();
    private T appSettings;

    public SettingsService(AppPreferences appPreferences, Class<T> settingsClazz, Supplier<T> defaultPreferencesSupplier) {
        this.appPreferences = appPreferences;
        this.settingsClazz = settingsClazz;
        this.defaultPreferencesSupplier = defaultPreferencesSupplier;
    }

    @PostConstruct
    public void init() {
        this.loadSettings();
    }

    private void loadSettings() {
        try {
            this.appSettings = (BasicAppSettings)this.appPreferences.get(PREF_KEY_SETTINGS, this.settingsClazz);
        }
        catch (Exception e) {
            this.appSettings = (BasicAppSettings)this.defaultPreferencesSupplier.get();
        }
    }

    public void saveSettings() {
        this.appPreferences.put(PREF_KEY_SETTINGS, this.appSettings);
    }

    public void fireSettingsChanged() {
        this.settingsChangedListeners.forEach(l -> l.accept(this.appSettings));
    }

    @Generated
    public List<Consumer<T>> getSettingsChangedListeners() {
        return this.settingsChangedListeners;
    }

    @Generated
    public T getAppSettings() {
        return this.appSettings;
    }
}

