/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.service;

import java.util.Locale;
import lombok.Generated;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.StaticMessageSource;

public class I18nService {
    private final MessageSource messageSource;
    private final Locale locale = Locale.GERMAN;

    public String t(String message, Object ... args) {
        try {
            return this.messageSource.getMessage(message, args, this.locale);
        }
        catch (NoSuchMessageException e) {
            return this.resolveStaticMessage(message, args);
        }
    }

    private String resolveStaticMessage(String message, Object ... args) {
        if (message == null) {
            return null;
        }
        StaticMessageSource ms = new StaticMessageSource();
        ms.addMessage(message, this.locale, message);
        return ms.getMessage(message, args, this.locale);
    }

    @Generated
    public I18nService(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }
}

