/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.service;

import jakarta.annotation.PostConstruct;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.AbstractActionService;
import net.schembs.solutions.desktopclient.service.AppAction;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.KeyboardHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionService
extends AbstractActionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActionService.class);
    private final I18nService i18n;
    private final Map<String, Boolean> actionsEnabled = new HashMap<String, Boolean>();

    @PostConstruct
    public void init() {
        this.initKeyboardMappings();
    }

    private void initKeyboardMappings() {
        this.loadKeyboardMappings("/keyboard-mappings");
    }

    @Override
    protected String getTitleForActionName(String actionName) {
        return this.i18n.t(actionName, new Object[0]);
    }

    @Override
    protected void applyKeyMapping(String actionName, AppAction action, KeyStroke keyStroke) {
        action.putValue("AcceleratorKey", keyStroke);
    }

    public void enforceActions(JComponent component) {
        this.actions.forEach((string, action) -> {
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (keyStroke != null) {
                KeyboardHelper.registerActionOnComponent(component, keyStroke, action);
            }
        });
    }

    public void enableGlobalActionsForNativeDialogs(boolean enable) {
        for (Map.Entry actionEntry : this.actions.entrySet()) {
            if (!enable) {
                this.actionsEnabled.put((String)actionEntry.getKey(), ((AppAction)actionEntry.getValue()).isEnabled());
                ((AppAction)actionEntry.getValue()).setEnabled(false);
                continue;
            }
            ((AppAction)actionEntry.getValue()).setEnabled(this.actionsEnabled.get(actionEntry.getKey()));
        }
    }

    public void consumeGlobalKeys(KeyEvent event) {
        if (event.getKeyCode() == 32) {
            event.consume();
        }
    }

    @Generated
    public ActionService(I18nService i18n) {
        this.i18n = i18n;
    }
}

