/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.KeyStroke;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.OperatingSystem;
import net.schembs.solutions.desktopclient.service.AppAction;
import net.schembs.solutions.desktopclient.ui.KeyboardHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractActionService.class);
    private static final Pattern REGEX_MULTI_ENTRY = Pattern.compile("(.+)\\.[0-9]+");
    protected final Map<String, AppAction> actions = new HashMap<String, AppAction>();

    public AppAction getAction(Enum<?> action) {
        return this.getAction(action.toString());
    }

    public AppAction getAction(String action) {
        return this.actions.computeIfAbsent(action, this::createAction);
    }

    private AppAction createAction(String action) {
        return new AppAction(action, this.getTitleForActionName(action));
    }

    protected abstract String getTitleForActionName(String var1);

    protected void loadKeyboardMappings(String mappingFilename) {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream(mappingFilename + "-" + OperatingSystem.getOS() + ".properties"));
        }
        catch (IOException e) {
            log.error("Failed to load keyboard-mappings");
        }
        for (String key : properties.stringPropertyNames()) {
            String actionName = this.getActionNamePrefix() + key;
            Matcher matcher = REGEX_MULTI_ENTRY.matcher(key);
            if (matcher.matches()) {
                actionName = this.getActionNamePrefix() + matcher.group(1);
            }
            String value = properties.getProperty(key);
            this.applyKeyMapping(actionName, value);
        }
    }

    protected String getActionNamePrefix() {
        return "action.";
    }

    private void applyKeyMapping(String actionName, String mapping) {
        AppAction action = this.getAction(actionName);
        KeyStroke keyStroke = KeyboardHelper.getKeyStrokeForMapping(mapping);
        this.applyKeyMapping(actionName, action, keyStroke);
    }

    protected abstract void applyKeyMapping(String var1, AppAction var2, KeyStroke var3);
}

