/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.controller;

import jakarta.annotation.PostConstruct;
import javax.swing.JDialog;
import javax.swing.JFrame;
import lombok.Generated;
import net.schembs.solutions.desktopclient.model.BasicAppSettings;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.ui.general.settings.CategorySelectionListener;
import net.schembs.solutions.desktopclient.ui.general.settings.SettingsCategoryPanel;
import net.schembs.solutions.desktopclient.ui.general.settings.SettingsPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSettingsController<T extends BasicAppSettings>
implements CategorySelectionListener<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSettingsController.class);
    private final I18nService i18n;
    protected final SettingsPanel<T> settingsPanel;
    private final SettingsService<T> settingsService;

    @PostConstruct
    public void init() {
        this.settingsPanel.setCategorySelectionListener(this);
        this.registerCategories();
    }

    protected abstract void registerCategories();

    protected abstract Enum<?> getInitialCategory();

    public void showSettings(JFrame parent) {
        JDialog settingsDialog = new JDialog(parent);
        settingsDialog.setTitle(this.i18n.t("settings.title", new Object[0]));
        settingsDialog.setModal(true);
        settingsDialog.setResizable(false);
        settingsDialog.getContentPane().add(this.settingsPanel);
        this.selectCategory(this.getInitialCategory());
        settingsDialog.pack();
        settingsDialog.setLocationRelativeTo(parent);
        settingsDialog.setVisible(true);
        this.settingsService.saveSettings();
        this.settingsService.fireSettingsChanged();
        parent.revalidate();
        parent.repaint();
    }

    protected void selectCategory(Enum<?> category) {
        this.selectCategory(category.name());
    }

    protected void selectCategory(String category) {
        this.settingsPanel.selectCategory(category);
    }

    @Override
    public void onPrepareCategoryPanel(SettingsCategoryPanel<T> panel) {
        panel.setSettings(this.settingsService.getAppSettings());
    }

    @Override
    public void onCategorySelected(String categoryName) {
        log.info("Category selected: {}", (Object)categoryName);
    }

    @Generated
    public AbstractSettingsController(I18nService i18n, SettingsPanel<T> settingsPanel, SettingsService<T> settingsService) {
        this.i18n = i18n;
        this.settingsPanel = settingsPanel;
        this.settingsService = settingsService;
    }
}

