/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.model.LayoutsConfig;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.UIUtils;
import net.schembs.solutions.desktopclient.ui.layout.AppLayoutBuilder;
import net.schembs.solutions.desktopclient.ui.layout.AppLayoutService;
import net.schembs.solutions.desktopclient.ui.osspecific.mac.Mac;
import net.schembs.solutions.desktopclient.ui.osspecific.mac.MacMainFrameConfigurator;
import net.schembs.solutions.desktopclient.ui.osspecific.mac.MacWindowFrameManager;
import net.schembs.solutions.desktopclient.ui.osspecific.win.Win;
import net.schembs.solutions.desktopclient.ui.osspecific.win.WinMainFrameConfigurator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DesktopClientBeansConfig {
    @Bean
    @Mac
    public MacWindowFrameManager macWindowFrameManager() {
        return new MacWindowFrameManager();
    }

    @Bean
    @Mac
    public MacMainFrameConfigurator macMainFrameConfigurator(MacWindowFrameManager windowFrameManager, AppLayoutService appLayoutService) {
        return new MacMainFrameConfigurator(windowFrameManager, appLayoutService);
    }

    @Bean
    @Win
    public WinMainFrameConfigurator winMainFrameConfigurator() {
        return new WinMainFrameConfigurator();
    }

    @Bean
    @ConditionalOnMissingBean(value={ColorConfig.class})
    public ColorConfig colorConfig() {
        return new ColorConfig();
    }

    @Bean
    @ConditionalOnMissingBean(value={ObjectMapper.class})
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Bean
    @ConditionalOnMissingBean(value={I18nService.class})
    public I18nService i18nService(MessageSource messageSource) {
        return new I18nService(messageSource);
    }

    @Bean
    @ConditionalOnMissingBean(value={ActionService.class})
    public ActionService actionService(I18nService i18nService) {
        return new ActionService(i18nService);
    }

    @Bean
    @ConditionalOnMissingBean(value={UIUtils.class})
    public UIUtils uiUtils(I18nService i18nService, ActionService actionService, ColorConfig colorConfig) {
        return new UIUtils(i18nService, actionService, colorConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={AppLayoutService.class})
    public AppLayoutService appLayoutService(AppLayoutBuilder appLayoutBuilder, AppPreferences appPreferences, LayoutsConfig layoutsConfig) {
        return new AppLayoutService(appLayoutBuilder, appPreferences, layoutsConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={AppLayoutBuilder.class})
    public AppLayoutBuilder appLayoutBuilder(ApplicationContext applicationContext, ColorConfig colorConfig) {
        return new AppLayoutBuilder(applicationContext, colorConfig);
    }
}

