/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.config;

import java.awt.Color;
import javax.annotation.PostConstruct;
import javax.swing.UIManager;
import net.schembs.solutions.desktopclient.ui.osspecific.UISystem;

public class ColorConfig {
    @PostConstruct
    public void init() {
        UIManager.put("Panel.background", this.getMainComponentBackground());
        UIManager.put("Tree.background", this.getMainComponentBackground());
    }

    public Color getShyLabelForeground() {
        return UISystem.isDarkMode() ? this.getLabelForeground().darker().darker() : new Color(160, 160, 160);
    }

    public Color getFocusMarker() {
        return this.getTableSelectionBackground();
    }

    public Color getBarBackground() {
        return this.getMainComponentBackground();
    }

    public Color getMainComponentBackground() {
        return UISystem.isDarkMode() ? new Color(40, 40, 40) : new Color(245, 245, 245);
    }

    public Color getSeparatorColor() {
        return UISystem.isDarkMode() ? new Color(30, 30, 30) : new Color(240, 240, 240);
    }

    public Color getTableForeground() {
        return UISystem.isDarkMode() ? UIManager.getColor("Table.foreground") : new Color(100, 100, 100);
    }

    public Color getTableBackground() {
        return UISystem.isDarkMode() ? new Color(40, 40, 40) : new Color(245, 245, 245);
    }

    public Color getTableAlternateBackground() {
        return UISystem.isDarkMode() ? this.getTableBackground().brighter() : new Color(230, 230, 230);
    }

    public Color getTableSelectionForeground() {
        return UIManager.getColor("Table.selectionForeground");
    }

    public Color getPrimaryColor() {
        return new Color(15, 130, 250);
    }

    public Color getTableSelectionBackground() {
        return UIManager.getColor("Table.selectionBackground");
    }

    public Color getTableSelectionNoFocusBackground() {
        return UISystem.isDarkMode() ? this.getShyLabelForeground() : Color.lightGray;
    }

    public Color getTableLeadSelectionBorderColor() {
        return this.getTableSelectionBackground().brighter();
    }

    public Color getTableMarkBackground() {
        return UISystem.isDarkMode() ? this.getTableMarkSelectedBackground().darker().darker() : this.getTableMarkSelectedBackground().darker();
    }

    public Color getTableMarkAlternateBackground() {
        return this.getTableMarkBackground().brighter();
    }

    public Color getTableMarkSelectedBackground() {
        return this.getTableSelectionBackground().brighter();
    }

    public Color getTableMarkForeground() {
        return this.getTableSelectionForeground();
    }

    public Color getLabelForeground() {
        return UISystem.isDarkMode() ? UIManager.getColor("Label.foreground") : new Color(100, 100, 100);
    }

    public Color getBorderColor() {
        return new Color(66, 66, 66);
    }

    public Color getToolBarIconColor() {
        return new Color(119, 119, 112);
    }

    public Color getToolBarPartBackground() {
        return this.getSeparatorColor();
    }

    public Color getToolBarButtonHoverBackground() {
        return Color.DARK_GRAY;
    }
}

