/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.desktopclient.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPreferences {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppPreferences.class);
    private final List<ShutdownHook> shutdownHooks = new ArrayList<ShutdownHook>();
    private final ObjectMapper objectMapper;
    private final Preferences prefs;

    public AppPreferences(Class<?> applicationClass, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.prefs = Preferences.userNodeForPackage(applicationClass);
    }

    public void put(String key, String value) {
        this.prefs.put(key, value);
    }

    public String get(String key) {
        return this.prefs.get(key, null);
    }

    public void remove(String key) {
        this.prefs.remove(key);
    }

    public void put(String key, Object value) {
        try {
            String s = this.objectMapper.writeValueAsString(value);
            this.put(key, s);
            log.debug("Store preference {} = {}", (Object)key, (Object)s);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T get(String key, Class<T> t) {
        try {
            String s = this.get(key);
            log.debug("Load preference {} = {}", (Object)key, (Object)s);
            return (T)this.objectMapper.readValue(s, t);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        this.shutdownHooks.forEach(shutdownHook -> shutdownHook.onShutdown(this));
    }

    @Generated
    public List<ShutdownHook> getShutdownHooks() {
        return this.shutdownHooks;
    }

    public static interface ShutdownHook {
        public void onShutdown(AppPreferences var1);
    }
}

