/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.supportedfiles;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTypeDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileTypeDetector.class);

    public FileType detectFileType(File file) {
        int len = 8;
        try {
            byte[] bytes = new byte[len];
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            bis.mark(len);
            int readBytes = bis.read(bytes);
            bis.close();
            String marker = new String(bytes);
            return readBytes == 8 && marker.startsWith("%PDF-") ? FileType.pdf : FileType.unknown;
        }
        catch (IOException e) {
            log.warn("Failed to read first {} bytes of {}", (Object)len, (Object)file.getName());
            return FileType.unknown;
        }
    }

    public static enum FileType {
        unknown,
        pdf;

    }
}

