/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.cli.ui.osspecific.mac;

import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.schembs.solutions.dms.cli.model.ParentWindow;
import net.schembs.solutions.dms.cli.ui.osspecific.AbstractOperationSystem;
import org.assertj.core.util.Strings;

/*
 * Exception performing whole class analysis ignored.
 */
public class MacOSSystem
extends AbstractOperationSystem {
    private static boolean isDarkMode() {
        try {
            String line;
            boolean isDarkMode = false;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("defaults read -g AppleInterfaceStyle");
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader rdr = new BufferedReader(isr);
            while ((line = rdr.readLine()) != null) {
                if (!line.equals("Dark")) continue;
                isDarkMode = true;
            }
            int rc = process.waitFor();
            return 0 == rc && isDarkMode;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    public static boolean setupPLaF() {
        System.setProperty("apple.awt.application.name", "SITC-DMS Client");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.application.appearance", "system");
        boolean darkMode = MacOSSystem.isDarkMode();
        if (darkMode) {
            FlatMacDarkLaf.setup();
        } else {
            FlatMacLightLaf.setup();
        }
        return darkMode;
    }

    public ParentWindow getParentWindow(String processName) {
        if (!Strings.isNullOrEmpty((String)processName)) {
            String cmd = "tell application \"%s\"\n\tproperties of window 0\nend tell\n\n".formatted(processName);
            ProcessBuilder pb = new ProcessBuilder("osascript", "-e", cmd);
            try {
                String line;
                Process process = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                    builder.append(System.lineSeparator());
                }
                return new ParentWindow(builder.toString());
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

