/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.cli.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class SettingLayout
implements LayoutManager {
    private final int vGap;

    public SettingLayout(int vGap) {
        this.vGap = vGap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        Dimension dim = new Dimension(0, insets.top + insets.bottom);
        for (Component comp : parent.getComponents()) {
            dim.height += comp.getPreferredSize().height;
            dim.width = Math.max(dim.width, comp.getPreferredSize().width + insets.left + insets.right);
        }
        dim.height += this.vGap * (parent.getComponentCount() - 1);
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension parentSize = parent.getSize();
        Insets insets = parent.getInsets();
        int y = insets.top;
        for (Component comp : parent.getComponents()) {
            int width = parentSize.width - insets.left - insets.right;
            comp.setBounds(insets.left, y, width, comp.getPreferredSize().height);
            y += comp.getPreferredSize().height + this.vGap;
        }
    }
}

