/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.cli.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Toolkit;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.schembs.solutions.dms.cli.model.UploadResult;
import net.schembs.solutions.dms.cli.ui.ResultPanel;
import net.schembs.solutions.dms.cli.ui.layout.SettingLayout;

public class ResultPanelImpl
extends JPanel
implements ResultPanel {
    public void createUI() {
        this.setLayout((LayoutManager)new SettingLayout(5));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public JPanel getPanel() {
        return this;
    }

    public void showResult(List<UploadResult> result, Runnable onClose) {
        for (UploadResult row : result) {
            Panel panel = new Panel(new FlowLayout(0));
            panel.add(new JLabel(this.getIcon(row.isSuccess() ? "success.png" : "error.png")));
            panel.add(new JLabel(row.getFileName() + (String)(row.isSuccess() ? "" : ": " + row.getError())));
            this.add((Component)panel);
        }
        JButton btn = new JButton("Ok");
        this.add((Component)btn);
        btn.addActionListener(e -> onClose.run());
    }

    private ImageIcon getIcon(String name) {
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/" + name)));
    }
}

