/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.cli.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import lombok.Generated;
import net.schembs.solutions.dms.cli.model.ParentWindow;
import net.schembs.solutions.dms.cli.model.UploadResult;
import net.schembs.solutions.dms.cli.ui.FilesPanel;
import net.schembs.solutions.dms.cli.ui.FilesPanelImpl;
import net.schembs.solutions.dms.cli.ui.MainFrame;
import net.schembs.solutions.dms.cli.ui.ResultPanel;
import net.schembs.solutions.dms.cli.ui.ResultPanelImpl;

public class MainFrameImpl
extends JDialog
implements MainFrame {
    private FilesPanel filesPanel;
    private ResultPanel resultPanel;
    private ParentWindow parentWindow;

    public void createUI(ParentWindow parentWindow) {
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.filesPanel = new FilesPanelImpl();
        this.filesPanel.createUI();
        this.getContentPane().add((Component)this.filesPanel.getPanel(), "Center");
        this.parentWindow = parentWindow;
        this.centerInParent();
        this.resultPanel = new ResultPanelImpl();
        this.resultPanel.createUI();
    }

    public void showResult(List<UploadResult> result, Runnable onResultFinished) {
        SwingUtilities.invokeLater(() -> {
            this.getContentPane().removeAll();
            this.getContentPane().add((Component)this.resultPanel.getPanel(), "Center");
            this.resultPanel.showResult(result, onResultFinished);
            this.centerInParent();
        });
    }

    private void centerInParent() {
        this.pack();
        if (this.parentWindow != null) {
            this.setLocation(this.parentWindow.getX() + (this.parentWindow.getWidth() - this.getWidth()) / 2, this.parentWindow.getY() + (this.parentWindow.getHeight() - this.getHeight()) / 2);
        }
    }

    @Generated
    public FilesPanel getFilesPanel() {
        return this.filesPanel;
    }

    @Generated
    public ResultPanel getResultPanel() {
        return this.resultPanel;
    }
}

