/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.cli.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import net.schembs.solutions.dms.cli.exception.DocumentStoreNoClientException;
import net.schembs.solutions.dms.cli.model.UploadResult;
import net.schembs.solutions.dms.cli.model.arguments.UploadArguments;
import net.schembs.solutions.dms.cli.service.CliConsole;
import net.schembs.solutions.dms.cli.service.DocumentStoreService;
import net.schembs.solutions.dms.cli.ui.FilesPanel;
import net.schembs.solutions.dms.cli.ui.MainFrame;
import net.schembs.solutions.dms.security.exception.LoginFailedException;
import net.schembs.solutions.dms.security.exception.TokenRefreshFailedException;
import net.schembs.solutions.dms.security.service.AuthService;
import net.schembs.solutions.dms.supportedfiles.FileTypeDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;

@Service
public class UploadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadService.class);
    private final AuthService authService;
    private final DocumentStoreService documentStoreService;
    private final MainFrame mainFrame;
    private final TaskExecutor applicationTaskExecutor;
    private final FileTypeDetector fileTypeDetector;
    private final CliConsole console;

    public void upload(UploadArguments arguments) {
        CountDownLatch latch = new CountDownLatch(1);
        this.applicationTaskExecutor.execute(() -> {
            this.getFilesPanel().setSubTitle("Logging in...");
            try {
                this.login(arguments);
                this.uploadFiles(arguments.getFiles(), arguments.isGui());
            }
            catch (DocumentStoreNoClientException e) {
                log.error(e.getMessage());
                if (arguments.isGui()) {
                    this.showResult(List.of(UploadResult.builder().fileName("Login").error(e.getMessage()).build()), arguments.isGui());
                }
            }
            catch (LoginFailedException e) {
                log.error(e.getMessage());
                String message = e.getMessage();
                Throwable patt0$temp = e.getCause();
                if (patt0$temp instanceof HttpClientErrorException) {
                    HttpClientErrorException httpClientErrorException = (HttpClientErrorException)patt0$temp;
                    message = httpClientErrorException.getStatusText();
                }
                if (arguments.isGui()) {
                    this.showResult(List.of(UploadResult.builder().fileName("Login").error(message).build()), arguments.isGui());
                }
            }
            finally {
                latch.countDown();
            }
        });
        if (!arguments.isGui()) {
            latch.await();
            this.shutdown(0);
        }
    }

    private void uploadFiles(List<Path> files, boolean isGui) {
        int filesUploaded = 0;
        ArrayList<UploadResult> results = new ArrayList<UploadResult>();
        for (Path path : files) {
            FileTypeDetector.FileType fileType;
            if (isGui) {
                this.getFilesPanel().setTitle(String.format("Uploading %d/%d", filesUploaded + 1, files.size()));
                this.getFilesPanel().setSubTitle(path.getFileName().toString());
            } else {
                this.console.log("Uploading %d/%d: %s", new Object[]{filesUploaded + 1, files.size(), path.getFileName().toString()});
            }
            UploadResult result = path.toFile().exists() ? ((fileType = this.fileTypeDetector.detectFileType(path.toFile())) == FileTypeDetector.FileType.pdf ? this.upload(path) : UploadResult.builder().fileName(path.getFileName().toString()).error("Invalid type").build()) : UploadResult.builder().fileName(path.getFileName().toString()).error("File does not exist").build();
            results.add(result);
            ++filesUploaded;
        }
        log.info("Uploaded {} files", (Object)filesUploaded);
        this.showResult(results, isGui);
    }

    private void showResult(List<UploadResult> results, boolean gui) {
        if (gui) {
            this.mainFrame.showResult(results, () -> {
                this.mainFrame.setVisible(false);
                this.shutdown(0);
            });
        } else {
            results.forEach(r -> this.console.log("%s %s%s", new Object[]{r.getError() == null ? "\u2705" : "\u274c", r.getFileName(), r.getError() == null ? "" : ": " + r.getError()}));
        }
    }

    private void login(UploadArguments arguments) {
        this.authService.getTokenRefreshListeners().add(arg_0 -> this.onTokenRefreshFailed(arg_0));
        this.authService.login(arguments.getUsername(), arguments.getPassword());
    }

    private UploadResult upload(Path path) {
        try {
            log.info("Uploading {}", (Object)path);
            byte[] data = Files.readAllBytes(path);
            this.documentStoreService.uploadDocument(path, data);
            log.info("Ok.");
            return UploadResult.builder().fileName(path.getFileName().toString()).success(true).build();
        }
        catch (IOException e) {
            log.error("Failed to upload {}: {}", (Object)path, (Object)e.getMessage());
            return UploadResult.builder().fileName(path.getFileName().toString()).error(e.getClass().getSimpleName()).build();
        }
    }

    private FilesPanel getFilesPanel() {
        return this.mainFrame.getFilesPanel();
    }

    private void shutdown(int exitCode) {
        log.info("Have a nice day!");
        System.exit(exitCode);
    }

    private void onTokenRefreshFailed(TokenRefreshFailedException tokenRefreshFailedException) {
        throw tokenRefreshFailedException;
    }

    @Generated
    public UploadService(AuthService authService, DocumentStoreService documentStoreService, MainFrame mainFrame, TaskExecutor applicationTaskExecutor, FileTypeDetector fileTypeDetector, CliConsole console) {
        this.authService = authService;
        this.documentStoreService = documentStoreService;
        this.mainFrame = mainFrame;
        this.applicationTaskExecutor = applicationTaskExecutor;
        this.fileTypeDetector = fileTypeDetector;
        this.console = console;
    }
}

